/*
 * Decompiled with CFR 0.152.
 */
package com.bignerdranch.expandablerecyclerview;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.bignerdranch.expandablerecyclerview.ExpandableRecyclerAdapter;
import com.bignerdranch.expandablerecyclerview.model.Parent;

public class ParentViewHolder<P extends Parent<C>, C>
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    @Nullable
    private ParentViewHolderExpandCollapseListener mParentViewHolderExpandCollapseListener;
    private boolean mExpanded = false;
    P mParent;
    ExpandableRecyclerAdapter mExpandableAdapter;

    @UiThread
    public ParentViewHolder(@NonNull View itemView) {
        super(itemView);
    }

    @UiThread
    public P getParent() {
        return this.mParent;
    }

    @UiThread
    public int getParentAdapterPosition() {
        int flatPosition = this.getAdapterPosition();
        if (flatPosition == -1) {
            return flatPosition;
        }
        return this.mExpandableAdapter.getNearestParentPosition(flatPosition);
    }

    @UiThread
    public void setMainItemClickToExpand() {
        this.itemView.setOnClickListener((View.OnClickListener)this);
    }

    @UiThread
    public boolean isExpanded() {
        return this.mExpanded;
    }

    @UiThread
    public void setExpanded(boolean expanded) {
        this.mExpanded = expanded;
    }

    @UiThread
    public void onExpansionToggled(boolean expanded) {
    }

    @UiThread
    void setParentViewHolderExpandCollapseListener(ParentViewHolderExpandCollapseListener parentViewHolderExpandCollapseListener) {
        this.mParentViewHolderExpandCollapseListener = parentViewHolderExpandCollapseListener;
    }

    @UiThread
    public void onClick(View v) {
        if (this.mExpanded) {
            this.collapseView();
        } else {
            this.expandView();
        }
    }

    @UiThread
    public boolean shouldItemViewClickToggleExpansion() {
        return true;
    }

    @UiThread
    protected void expandView() {
        this.setExpanded(true);
        this.onExpansionToggled(false);
        if (this.mParentViewHolderExpandCollapseListener != null) {
            this.mParentViewHolderExpandCollapseListener.onParentExpanded(this.getAdapterPosition());
        }
    }

    @UiThread
    protected void collapseView() {
        this.setExpanded(false);
        this.onExpansionToggled(true);
        if (this.mParentViewHolderExpandCollapseListener != null) {
            this.mParentViewHolderExpandCollapseListener.onParentCollapsed(this.getAdapterPosition());
        }
    }

    static interface ParentViewHolderExpandCollapseListener {
        @UiThread
        public void onParentExpanded(int var1);

        @UiThread
        public void onParentCollapsed(int var1);
    }
}

