/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.interceptor.configuration;

import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.sdk.gateway.pop.exception.PopClientException;
import darabonba.core.TeaConfiguration;
import darabonba.core.TeaRequest;
import darabonba.core.interceptor.ConfigurationInterceptor;
import darabonba.core.interceptor.InterceptorContext;

public class EndpointInterceptor
implements ConfigurationInterceptor {
    private final ClientLogger logger = new ClientLogger(EndpointInterceptor.class);

    public TeaConfiguration modifyConfiguration(InterceptorContext context, AttributeMap attributes) {
        this.logger.info("Endpoint pre-process begin.");
        TeaRequest request = context.teaRequest();
        TeaConfiguration configuration = context.configuration();
        if (!StringUtils.isEmpty((CharSequence)configuration.endpoint())) {
            return configuration;
        }
        if (!StringUtils.isEmpty((CharSequence)configuration.region()) && !request.endpointMap().isEmpty() && request.endpointMap().containsKey(configuration.region())) {
            configuration.setEndpoint((String)request.endpointMap().get(configuration.region()));
            return configuration;
        }
        String endpointType = "";
        if (!StringUtils.isEmpty((CharSequence)configuration.endpointType()) && !configuration.endpointType().equals("public")) {
            endpointType = "-" + configuration.endpointType();
        }
        if (request.endpointRule().equals("regional")) {
            if (StringUtils.isEmpty((CharSequence)configuration.region())) {
                throw new PopClientException("RegionId is empty, please set a valid RegionId", new RuntimeException("RegionId is empty, please set a valid RegionId"));
            }
            configuration.setEndpoint(String.format("%s%s.%s.aliyuncs.com", request.product(), endpointType, configuration.region()));
        } else {
            configuration.setEndpoint(String.format("%s%s.aliyuncs.com", request.product(), endpointType));
        }
        return configuration;
    }

    protected static final class EndpointRule {
        public static final String Regional = "regional";
        public static final String SEPARATOR = "-";

        protected EndpointRule() {
        }
    }
}

