/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderUTF16;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.UUIDUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;

final class JSONReaderJSONB
extends JSONReader {
    static Charset GB18030;
    private final byte[] bytes;
    private final int length;
    private final int end;
    private byte type;
    private int strlen;
    private byte strtype;
    private int strBegin;
    private byte[] valueBytes;
    private final int cachedIndex = JSONFactory.cacheIndex();
    private final SymbolTable symbolTable;
    private long[] symbols = new long[16];
    private static BiFunction<char[], Boolean, String> STRING_CREATOR_JDK8;
    private static Function<byte[], String> STRING_CREATOR_JDK11;
    private static volatile boolean STRING_CREATOR_ERROR;

    JSONReaderJSONB(JSONReader.Context ctx, byte[] bytes, int off, int length) {
        super(ctx);
        this.bytes = bytes;
        this.offset = off;
        this.length = length;
        this.end = off + length;
        this.symbolTable = ctx.symbolTable;
    }

    @Override
    public boolean isJSONB() {
        return true;
    }

    @Override
    public String getString() {
        Charset charset;
        if (this.strtype == -81) {
            return null;
        }
        if (this.strlen < 0) {
            return this.symbolTable.getName(-this.strlen);
        }
        if (this.strtype == 121) {
            charset = StandardCharsets.US_ASCII;
        } else if (this.strtype >= 73 && this.strtype <= 120) {
            charset = StandardCharsets.US_ASCII;
        } else if (this.strtype == 122) {
            charset = StandardCharsets.UTF_8;
        } else if (this.strtype == 123) {
            charset = StandardCharsets.UTF_16;
        } else if (this.strtype == 124) {
            charset = StandardCharsets.UTF_16LE;
        } else if (this.strtype == 125) {
            charset = StandardCharsets.UTF_16BE;
        } else {
            throw new JSONException("TODO : " + JSONB.typeName(this.strtype));
        }
        return new String(this.bytes, this.strBegin, this.strlen, charset);
    }

    public int readLength() {
        byte type;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type == 72) {
            int len;
            if ((len = (this.bytes[this.offset++] << 24) + ((this.bytes[this.offset++] & 0xFF) << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF)) > 0x10000000) {
                throw new JSONException("input length overflow");
            }
            return len;
        }
        throw new JSONException("not support length type : " + JSONB.typeName(type));
    }

    @Override
    public boolean isArray() {
        if (this.offset >= this.bytes.length) {
            return false;
        }
        byte type = this.bytes[this.offset];
        return type >= -108 && type <= -92;
    }

    @Override
    public boolean isObject() {
        return this.offset < this.end && this.bytes[this.offset] == -90;
    }

    @Override
    public boolean isNumber() {
        byte type = this.bytes[this.offset];
        return type >= -76 && type <= 72;
    }

    @Override
    public boolean isString() {
        return this.offset < this.bytes.length && (this.type = this.bytes[this.offset]) >= 73;
    }

    @Override
    public boolean nextIfMatch(char ch) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfObjectStart() {
        if (this.bytes[this.offset] != -90) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public boolean nextIfObjectEnd() {
        if (this.bytes[this.offset] != -91) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public boolean nextIfEmptyString() {
        if (this.bytes[this.offset] != 73) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public <T> T read(Type type) {
        boolean fieldBased = (this.context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readJSONBObject(this, null, null, 0L);
    }

    @Override
    public <T> T read(Class<T> type) {
        boolean fieldBased = (this.context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readJSONBObject(this, null, null, 0L);
    }

    @Override
    public Map<String, Object> readObject() {
        this.type = this.bytes[this.offset++];
        if (this.type == -81) {
            return null;
        }
        if (this.type == -110) {
            ObjectReader objectReader = this.checkAutoType(Map.class, 0L, 0L);
            return (Map)objectReader.readObject(this, null, null, 0L);
        }
        if (this.type >= -90) {
            JSONObject map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject();
            int i = 0;
            while (true) {
                this.type = this.bytes[this.offset];
                if (this.type == -91) {
                    ++this.offset;
                    break;
                }
                String name = this.readFieldName();
                if (this.isReference()) {
                    String reference = this.readReference();
                    if ("..".equals(reference)) {
                        map.put(name, map);
                    } else {
                        this.addResolveTask(map, (Object)name, JSONPath.of(reference));
                    }
                } else {
                    Object value = this.readAny();
                    map.put(name, value);
                }
                ++i;
            }
            return map;
        }
        throw new JSONException("object not support input " + this.error(this.type));
    }

    @Override
    public Object readAny() {
        if (this.offset >= this.bytes.length) {
            throw new JSONException("readAny overflow : " + this.offset + "/" + this.bytes.length);
        }
        this.type = this.bytes[this.offset++];
        switch (this.type) {
            case -81: {
                return null;
            }
            case -79: {
                return true;
            }
            case -80: {
                return false;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                return (short)((this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF));
            }
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return new Integer(int32Value);
            }
            case -65: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return new Long(int32Value);
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return int64Value;
            }
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return Float.valueOf(Float.intBitsToFloat(int32Value));
            }
            case -74: {
                return Float.valueOf(this.readInt32Value());
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return Double.longBitsToDouble(int64Value);
            }
            case -76: {
                return (double)this.readInt64Value();
            }
            case 122: {
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                return str;
            }
            case 123: {
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16);
                this.offset += strlen;
                return str;
            }
            case 124: {
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                return str;
            }
            case 125: {
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16BE);
                this.offset += strlen;
                return str;
            }
            case 126: {
                if (GB18030 == null) {
                    GB18030 = Charset.forName("GB18030");
                }
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, GB18030);
                this.offset += strlen;
                return str;
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal;
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case -111: {
                int len = this.readLength();
                byte[] binary = Arrays.copyOfRange(this.bytes, this.offset, this.offset + len);
                this.offset += len;
                return binary;
            }
            case -83: {
                long minutes = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return new Date(minutes * 60L * 1000L);
            }
            case -84: {
                long seconds = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return new Date(seconds * 1000L);
            }
            case -85: {
                long millis = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return new Date(millis);
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -110: {
                String typeName;
                boolean supportAutoType;
                long typeHash = this.readTypeHashCode();
                boolean bl = supportAutoType = (this.context.features & JSONReader.Feature.SupportAutoType.mask) != 0L;
                if (!supportAutoType) {
                    if (this.isObject()) {
                        return this.readObject();
                    }
                    throw new JSONException("auoType not support , offset " + this.offset + "/" + this.bytes.length);
                }
                ObjectReader autoTypeObjectReader = this.context.getObjectReaderAutoType(typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = this.context.getObjectReaderAutoType(typeName = this.getString(), null)) == null) {
                    throw new JSONException("auoType not support : " + typeName + ", offset " + this.offset + "/" + this.bytes.length);
                }
                return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
            }
            case -78: {
                return 0.0;
            }
            case -77: {
                return 1.0;
            }
            case -112: {
                int intValue = this.readInt32Value();
                return Character.valueOf((char)intValue);
            }
            case -90: {
                HashMap map = null;
                boolean supportAutoType = (this.context.features & JSONReader.Feature.SupportAutoType.mask) != 0L;
                int i = 0;
                while (true) {
                    Object name;
                    byte type;
                    if ((type = this.bytes[this.offset]) == -91) {
                        ++this.offset;
                        break;
                    }
                    if (i == 0 && type >= 73 && type <= 126) {
                        long hash = this.readFieldNameHashCode();
                        if (hash == ObjectReader.HASH_TYPE && supportAutoType) {
                            String typeName;
                            long typeHash = this.readValueHashCode();
                            ObjectReader autoTypeObjectReader = this.context.getObjectReaderAutoType(typeHash);
                            if (autoTypeObjectReader == null && (autoTypeObjectReader = this.context.getObjectReaderAutoType(typeName = this.getString(), null)) == null) {
                                throw new JSONException("auotype not support : " + typeName + ", offset " + this.offset + "/" + this.bytes.length);
                            }
                            this.typeRedirect = true;
                            return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
                        }
                        name = this.getFieldName();
                    } else {
                        name = type >= 73 && type <= 127 ? this.readFieldName() : this.readAny();
                    }
                    if (map == null) {
                        map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject();
                    }
                    if (this.isReference()) {
                        String reference = this.readReference();
                        if ("..".equals(reference)) {
                            map.put(name, map);
                        } else {
                            this.addResolveTask(map, name, JSONPath.of(reference));
                            map.put(name, null);
                        }
                    } else {
                        Object value = this.readAny();
                        map.put(name, value);
                    }
                    ++i;
                }
                if (map == null) {
                    map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject();
                }
                return map;
            }
        }
        if (this.type >= -16 && this.type <= 47) {
            return (int)this.type;
        }
        if (this.type >= 48 && this.type <= 63) {
            return (this.type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (this.type >= 64 && this.type <= 71) {
            return (this.type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (this.type >= -40 && this.type <= -17) {
            return -8L + (long)(this.type - -40);
        }
        if (this.type >= -56 && this.type <= -41) {
            return (long)(this.type - -48 << 8) + (long)(this.bytes[this.offset++] & 0xFF);
        }
        if (this.type >= -64 && this.type <= -57) {
            return (long)((this.type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF));
        }
        if (this.type >= -108 && this.type <= -92) {
            int len;
            int n = len = this.type == -92 ? this.readLength() : this.type - -108;
            if (len == 0) {
                if ((this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L) {
                    return new ArrayList();
                }
                if (this.context.arraySupplier != null) {
                    return this.context.arraySupplier.get();
                }
                return new JSONArray();
            }
            JSONArray list = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList(len) : new JSONArray(len);
            for (int i = 0; i < len; ++i) {
                if (this.isReference()) {
                    String reference = this.readReference();
                    if ("..".equals(reference)) {
                        list.add(list);
                        continue;
                    }
                    list.add(null);
                    this.addResolveTask(list, i, JSONPath.of(reference));
                    continue;
                }
                Object item = this.readAny();
                list.add(item);
            }
            return list;
        }
        if (this.type >= 73 && this.type <= 121) {
            int n = this.strlen = this.type == 121 ? this.readLength() : this.type - 73;
            if (this.strlen < 0) {
                return this.symbolTable.getName(-this.strlen);
            }
            String str = new String(this.bytes, this.offset, this.strlen, StandardCharsets.US_ASCII);
            this.offset += this.strlen;
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            return str;
        }
        throw new JSONException("not support type : " + this.error(this.type));
    }

    @Override
    public byte getType() {
        return this.bytes[this.offset];
    }

    @Override
    public List readArray() {
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            array.add(this.readAny());
        }
        return array;
    }

    @Override
    public List readArray(Type itemType) {
        if (this.nextIfNull()) {
            return null;
        }
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            array.add(this.read(itemType));
        }
        return array;
    }

    @Override
    public boolean isReference() {
        return this.offset < this.bytes.length && this.bytes[this.offset] == -109;
    }

    @Override
    public String readReference() {
        if (this.bytes[this.offset] != -109) {
            return null;
        }
        ++this.offset;
        if (this.isString()) {
            return this.readString();
        }
        throw new JSONException("reference not support input " + this.error(this.type));
    }

    @Override
    public ObjectReader checkAutoType(Class expectClass, long expectClassHash, long features) {
        ObjectReader autoTypeObjectReader = null;
        this.type = this.bytes[this.offset];
        if (this.type == -110) {
            ClassLoader contextClassLoader;
            ClassLoader objectClassLoader;
            Class objectClass;
            boolean isSupportAutoType;
            ObjectReader objectReader;
            String typeName;
            ObjectReader objectReader2;
            Class<Object> objectClass2;
            ++this.offset;
            long typeHash = this.readTypeHashCode();
            if (expectClassHash == typeHash && (objectClass2 = (objectReader2 = this.context.getObjectReader(expectClass)).getObjectClass()) != null && objectClass2 == expectClass) {
                this.context.getProvider().registerIfAbsent(typeHash, objectReader2);
                return objectReader2;
            }
            if (this.context.autoTypeBeforeHandler != null && (objectClass2 = this.context.autoTypeBeforeHandler.apply(typeName = this.getString(), expectClass, features)) != null && (objectReader = this.context.getObjectReader(objectClass2)) != null) {
                return objectReader;
            }
            boolean bl = isSupportAutoType = ((this.context.features | features) & JSONReader.Feature.SupportAutoType.mask) != 0L;
            if (!isSupportAutoType) {
                String typeName2 = this.getString();
                throw new JSONException("autoType not support input " + typeName2);
            }
            ObjectReaderProvider provider = this.context.provider;
            autoTypeObjectReader = provider.getObjectReader(typeHash);
            if (autoTypeObjectReader != null && (objectClass = autoTypeObjectReader.getObjectClass()) != null && (objectClassLoader = objectClass.getClassLoader()) != null && objectClassLoader != (contextClassLoader = Thread.currentThread().getContextClassLoader())) {
                String typeName3 = this.getString();
                Class<?> contextClass = TypeUtils.getMapping(typeName3);
                if (contextClass == null) {
                    try {
                        contextClass = contextClassLoader.loadClass(typeName3);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (contextClass != null && !objectClass.equals(contextClass)) {
                    autoTypeObjectReader = this.getObjectReader(contextClass);
                }
            }
            if (autoTypeObjectReader == null) {
                String typeName4 = this.getString();
                autoTypeObjectReader = provider.getObjectReader(typeName4, expectClass, this.context.features | features);
            }
            if (autoTypeObjectReader == null) {
                throw new JSONException("auotype not support : " + this.getString());
            }
            this.type = this.bytes[this.offset];
        }
        return autoTypeObjectReader;
    }

    @Override
    public int startArray() {
        this.type = this.bytes[this.offset++];
        if (this.type == -81) {
            return -1;
        }
        if (this.type >= -108 && this.type <= -93) {
            this.ch = (char)(-this.type);
            return this.type - -108;
        }
        if (this.type == -111) {
            return this.readInt32Value();
        }
        if (this.type != -92) {
            throw new JSONException("array not support input " + this.error(this.type));
        }
        return this.readInt32Value();
    }

    public String error(byte type) {
        StringBuilder buf = new StringBuilder();
        buf.append(JSONB.typeName(type));
        if (this.isString()) {
            int mark = this.offset--;
            String str = null;
            try {
                str = this.readString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (str != null) {
                buf.append(' ');
                buf.append(str);
            }
            this.offset = mark;
        }
        buf.append(", offset ");
        buf.append(this.offset);
        buf.append('/');
        buf.append(this.bytes.length);
        return buf.toString();
    }

    @Override
    public void next() {
        ++this.offset;
    }

    @Override
    public long readFieldNameHashCode() {
        long hashCode;
        boolean typeSymbol;
        this.strtype = this.bytes[this.offset++];
        boolean bl = typeSymbol = this.strtype == 127;
        if (typeSymbol) {
            this.strtype = this.bytes[this.offset];
            if (this.strtype >= -16 && this.strtype <= 72) {
                int symbol;
                if (this.strtype >= -16 && this.strtype <= 47) {
                    ++this.offset;
                    symbol = this.strtype;
                } else {
                    symbol = this.readInt32Value();
                }
                if (symbol < 0) {
                    return this.symbolTable.getHashCode(-symbol);
                }
                int index = symbol * 2;
                return this.symbols[index];
            }
            ++this.offset;
        }
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.strlen = this.strtype - 73;
        } else if (this.strtype == 121 || this.strtype == 122) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else {
            StringBuffer message = new StringBuffer().append("fieldName not support input type ").append(JSONB.typeName(this.strtype));
            if (this.strtype == -109) {
                message.append(" ").append(this.readString());
            }
            message.append(", offset ").append(this.offset);
            throw new JSONException(message.toString());
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else {
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; ++i) {
                byte c = this.bytes[this.offset++];
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        }
        if (typeSymbol) {
            int symbol;
            this.type = this.bytes[this.offset];
            if (this.type >= -16 && this.type <= 47) {
                symbol = this.type;
                ++this.offset;
            } else {
                symbol = this.readInt32Value();
            }
            long strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)this.strtype;
            int minCapacity = symbol * 2 + 2;
            if (this.symbols.length < minCapacity) {
                this.symbols = Arrays.copyOf(this.symbols, minCapacity + 16);
            }
            this.symbols[symbol * 2] = hashCode;
            this.symbols[symbol * 2 + 1] = strInfo;
        }
        return hashCode;
    }

    @Override
    public boolean isInt() {
        byte type = this.bytes[this.offset];
        return type >= -70 && type <= 72 || type == -84 || type == -83 || type == -85;
    }

    @Override
    public boolean isNull() {
        return this.bytes[this.offset] == -81;
    }

    @Override
    public Date readNullOrNewDate() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfNull() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public void readNull() {
        this.type = this.bytes[this.offset++];
        if (this.type != -81) {
            throw new JSONException("null not match, " + this.type);
        }
    }

    @Override
    public boolean readIfNull() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public long readTypeHashCode() {
        long strInfo;
        int symbol;
        byte c1;
        byte c0;
        int i;
        int c;
        long hashCode;
        this.strtype = this.bytes[this.offset];
        if (this.strtype >= -16 && this.strtype <= 72) {
            long refTypeHash;
            int typeIndex = this.readInt32Value();
            if (typeIndex < 0) {
                this.strlen = this.strtype;
                refTypeHash = this.symbolTable.getHashCode(-typeIndex);
            } else {
                refTypeHash = this.symbols[typeIndex * 2];
                if (refTypeHash == 0L) {
                    long strInfo2 = this.symbols[typeIndex * 2 + 1];
                    this.strtype = (byte)strInfo2;
                    this.strlen = (int)strInfo2 >> 8;
                    this.strBegin = (int)(strInfo2 >> 32);
                    refTypeHash = Fnv.hashCode64(this.getString());
                }
            }
            if (refTypeHash == -1L) {
                throw new JSONException("type ref not found : " + typeIndex);
            }
            return refTypeHash;
        }
        ++this.offset;
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.strlen = this.strtype - 73;
        } else if (this.strtype == 121 || this.strtype == 122 || this.strtype == 123 || this.strtype == 124 || this.strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else {
            throw new JSONException("string value not support input " + JSONB.typeName(this.type) + " offset " + this.offset + "/" + this.bytes.length);
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else if (this.strtype == 122) {
            hashCode = -3750763034362895579L;
            int end = this.offset + this.strlen;
            while (this.offset < end) {
                c = this.bytes[this.offset];
                if (c >= 0) {
                    ++this.offset;
                } else {
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = this.bytes[this.offset + 1];
                            if ((c2 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            this.offset += 2;
                            break;
                        }
                        case 14: {
                            byte c2 = this.bytes[this.offset + 1];
                            byte c3 = this.bytes[this.offset + 2];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            this.offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + this.offset);
                        }
                    }
                }
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 123 || this.strtype == 125) {
            hashCode = -3750763034362895579L;
            for (i = 0; i < this.strlen; i += 2) {
                c0 = this.bytes[this.offset + i];
                c1 = this.bytes[this.offset + i + 1];
                char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 124) {
            hashCode = -3750763034362895579L;
            for (i = 0; i < this.strlen; i += 2) {
                c0 = this.bytes[this.offset + i];
                c1 = this.bytes[this.offset + i + 1];
                char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else {
            hashCode = -3750763034362895579L;
            for (i = 0; i < this.strlen; ++i) {
                c = this.bytes[this.offset++];
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        }
        this.type = this.bytes[this.offset];
        if (this.type >= -16 && this.type <= 47) {
            symbol = this.type;
            ++this.offset;
        } else {
            symbol = this.readInt32Value();
        }
        int minCapacity = symbol * 2 + 2;
        if (this.symbols.length < minCapacity) {
            this.symbols = Arrays.copyOf(this.symbols, this.symbols.length + 16);
        }
        this.symbols[symbol * 2 + 1] = strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)this.strtype;
        return hashCode;
    }

    @Override
    public long readValueHashCode() {
        long hashCode;
        this.strtype = this.bytes[this.offset];
        ++this.offset;
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.strlen = this.strtype - 73;
        } else if (this.strtype == 121 || this.strtype == 122 || this.strtype == 123 || this.strtype == 124 || this.strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else {
            throw new JSONException("string value not support input " + JSONB.typeName(this.type) + " offset " + this.offset + "/" + this.bytes.length);
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else if (this.strtype == 122) {
            hashCode = -3750763034362895579L;
            int end = this.offset + this.strlen;
            while (this.offset < end) {
                int c = this.bytes[this.offset];
                if (c >= 0) {
                    ++this.offset;
                } else {
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = this.bytes[this.offset + 1];
                            if ((c2 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            this.offset += 2;
                            break;
                        }
                        case 14: {
                            byte c2 = this.bytes[this.offset + 1];
                            byte c3 = this.bytes[this.offset + 2];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            this.offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + this.offset);
                        }
                    }
                }
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 123) {
            hashCode = -3750763034362895579L;
            if (this.bytes[this.offset] == -2 && this.bytes[this.offset + 1] == -1) {
                for (int i = 2; i < this.strlen; i += 2) {
                    byte c0 = this.bytes[this.offset + i];
                    byte c1 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            } else if (this.bytes[this.offset] == -1 && this.bytes[this.offset + 1] == -2) {
                for (int i = 2; i < this.strlen; i += 2) {
                    byte c1 = this.bytes[this.offset + i];
                    byte c0 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            } else {
                for (int i = 0; i < this.strlen; i += 2) {
                    byte c0 = this.bytes[this.offset + i];
                    byte c1 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            }
        } else if (this.strtype == 125) {
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                byte c0 = this.bytes[this.offset + i];
                byte c1 = this.bytes[this.offset + i + 1];
                char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 124) {
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                byte c0 = this.bytes[this.offset + i];
                byte c1 = this.bytes[this.offset + i + 1];
                char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else {
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; ++i) {
                byte c = this.bytes[this.offset++];
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        }
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        int offset = this.strBegin;
        long hashCode = -3750763034362895579L;
        for (int i = 0; i < this.strlen; ++i) {
            byte c;
            if ((c = this.bytes[offset++]) >= 65 && c <= 90) {
                c = (byte)(c + 32);
            }
            if (c == 95) continue;
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public void skipValue() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -108: 
            case -81: 
            case -80: 
            case -79: 
            case 73: {
                return;
            }
            case -67: {
                ++this.offset;
                return;
            }
            case -68: {
                this.offset += 2;
                return;
            }
            case -84: 
            case -83: 
            case -73: 
            case 72: {
                this.offset += 4;
                return;
            }
            case -74: {
                this.readInt32Value();
                return;
            }
            case -85: 
            case -75: 
            case -66: {
                this.offset += 8;
                return;
            }
            case -76: {
                this.readInt64Value();
                return;
            }
            case -71: {
                this.readInt32Value();
                this.readBigInteger();
                return;
            }
            case -72: {
                this.readInt64Value();
                return;
            }
            case -89: {
                this.offset += 3;
                this.readInt32Value();
                return;
            }
            case -88: {
                this.offset += 7;
                this.readInt32Value();
                return;
            }
            case -86: {
                this.offset += 7;
                this.readInt32Value();
                this.readString();
                return;
            }
            case -111: {
                int byteslen = this.readInt32Value();
                this.offset += byteslen;
                return;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                int strlen = this.readInt32Value();
                this.offset += strlen;
                return;
            }
            case -110: {
                this.readTypeHashCode();
                this.skipValue();
                return;
            }
            case -90: {
                int i = 0;
                while (true) {
                    if (this.bytes[this.offset] == -91) {
                        ++this.offset;
                        break;
                    }
                    this.skipName();
                    this.skipValue();
                    ++i;
                }
                return;
            }
            case -109: {
                if (this.isString()) {
                    this.skipName();
                    return;
                }
                throw new JSONException("skip not support type " + JSONB.typeName(type));
            }
        }
        if (type >= -16 && type <= 47) {
            return;
        }
        if (type >= -40 && type <= -17) {
            return;
        }
        if (type >= 48 && type <= 63) {
            ++this.offset;
            return;
        }
        if (type >= 73 && type <= 120) {
            this.offset += type - 73;
            return;
        }
        if (type >= -108 && type <= -92) {
            int itemCnt = type == -92 ? this.readInt32Value() : type - -108;
            for (int i = 0; i < itemCnt; ++i) {
                this.skipValue();
            }
            return;
        }
        throw new JSONException("skip not support type " + JSONB.typeName(type));
    }

    @Override
    public boolean skipName() {
        this.strtype = this.bytes[this.offset++];
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.offset += this.strtype - 73;
            return true;
        }
        if (this.strtype == 121 || this.strtype == 122 || this.strtype == 123 || this.strtype == 124 || this.strtype == 125) {
            this.strlen = this.readLength();
            this.offset += this.strlen;
            return true;
        }
        if (this.strtype >= 73 && this.strtype <= 125) {
            return true;
        }
        if (this.strtype == 127) {
            byte type = this.bytes[this.offset];
            if (type >= -16 && type <= 72) {
                this.readInt32Value();
                return true;
            }
            String str = this.readString();
            this.readInt32Value();
            return true;
        }
        throw new JSONException("name not support input : " + JSONB.typeName(this.strtype));
    }

    @Override
    public String readFieldName() {
        boolean typeSymbol;
        this.strtype = this.bytes[this.offset];
        if (this.strtype == -81) {
            ++this.offset;
            return null;
        }
        ++this.offset;
        boolean bl = typeSymbol = this.strtype == 127;
        if (typeSymbol) {
            this.strtype = this.bytes[this.offset];
            if (this.strtype >= -16 && this.strtype <= 72) {
                int symbol = this.readInt32Value();
                if (symbol < 0) {
                    return this.symbolTable.getName(-symbol);
                }
                int index = symbol * 2 + 1;
                long strInfo = this.symbols[index];
                this.strtype = (byte)strInfo;
                this.strlen = (int)strInfo >> 8;
                this.strBegin = (int)(strInfo >> 32);
                return this.getString();
            }
            ++this.offset;
        }
        this.strBegin = this.offset;
        Charset charset = null;
        String str = null;
        if (this.strtype >= 73 && this.strtype <= 121) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            if (this.strtype == 121) {
                this.strlen = this.readLength();
                this.strBegin = this.offset;
            } else {
                this.strlen = this.strtype - 73;
                switch (this.strlen) {
                    case 1: {
                        nameValue0 = this.bytes[this.offset];
                        break;
                    }
                    case 2: {
                        nameValue0 = (this.bytes[this.offset] << 8) + this.bytes[this.offset + 1];
                        break;
                    }
                    case 3: {
                        nameValue0 = (this.bytes[this.offset] << 16) + (this.bytes[this.offset + 1] << 8) + this.bytes[this.offset + 2];
                        break;
                    }
                    case 4: {
                        nameValue0 = (this.bytes[this.offset] << 24) + (this.bytes[this.offset + 1] << 16) + (this.bytes[this.offset + 2] << 8) + this.bytes[this.offset + 3];
                        break;
                    }
                    case 5: {
                        nameValue0 = ((long)this.bytes[this.offset] << 32) + ((long)this.bytes[this.offset + 1] << 24) + ((long)this.bytes[this.offset + 2] << 16) + ((long)this.bytes[this.offset + 3] << 8) + (long)this.bytes[this.offset + 4];
                        break;
                    }
                    case 6: {
                        nameValue0 = ((long)this.bytes[this.offset] << 40) + ((long)this.bytes[this.offset + 1] << 32) + ((long)this.bytes[this.offset + 2] << 24) + ((long)this.bytes[this.offset + 3] << 16) + ((long)this.bytes[this.offset + 4] << 8) + (long)this.bytes[this.offset + 5];
                        break;
                    }
                    case 7: {
                        nameValue0 = ((long)this.bytes[this.offset] << 48) + ((long)this.bytes[this.offset + 1] << 40) + ((long)this.bytes[this.offset + 2] << 32) + ((long)this.bytes[this.offset + 3] << 24) + ((long)this.bytes[this.offset + 4] << 16) + ((long)this.bytes[this.offset + 5] << 8) + (long)this.bytes[this.offset + 6];
                        break;
                    }
                    case 8: {
                        nameValue0 = ((long)this.bytes[this.offset] << 56) + ((long)this.bytes[this.offset + 1] << 48) + ((long)this.bytes[this.offset + 2] << 40) + ((long)this.bytes[this.offset + 3] << 32) + ((long)this.bytes[this.offset + 4] << 24) + ((long)this.bytes[this.offset + 5] << 16) + ((long)this.bytes[this.offset + 6] << 8) + (long)this.bytes[this.offset + 7];
                        break;
                    }
                    case 9: {
                        nameValue0 = this.bytes[this.offset + 0];
                        nameValue1 = ((long)this.bytes[this.offset] + 1L << 56) + ((long)this.bytes[this.offset + 2] << 48) + ((long)this.bytes[this.offset + 3] << 40) + ((long)this.bytes[this.offset + 4] << 32) + ((long)this.bytes[this.offset + 5] << 24) + ((long)this.bytes[this.offset + 6] << 16) + ((long)this.bytes[this.offset + 7] << 8) + (long)this.bytes[this.offset + 8];
                        break;
                    }
                    case 10: {
                        nameValue0 = (this.bytes[this.offset] << 8) + this.bytes[this.offset + 1];
                        nameValue1 = ((long)this.bytes[this.offset + 2] << 56) + ((long)this.bytes[this.offset + 3] << 48) + ((long)this.bytes[this.offset + 4] << 40) + ((long)this.bytes[this.offset + 5] << 32) + ((long)this.bytes[this.offset + 6] << 24) + ((long)this.bytes[this.offset + 7] << 16) + ((long)this.bytes[this.offset + 8] << 8) + (long)this.bytes[this.offset + 9];
                        break;
                    }
                    case 11: {
                        nameValue0 = (this.bytes[this.offset] << 16) + (this.bytes[this.offset + 1] << 8) + this.bytes[this.offset + 2];
                        nameValue1 = ((long)this.bytes[this.offset + 3] << 56) + ((long)this.bytes[this.offset + 4] << 48) + ((long)this.bytes[this.offset + 5] << 40) + ((long)this.bytes[this.offset + 6] << 32) + ((long)this.bytes[this.offset + 7] << 24) + ((long)this.bytes[this.offset + 8] << 16) + ((long)this.bytes[this.offset + 9] << 8) + (long)this.bytes[this.offset + 10];
                        break;
                    }
                    case 12: {
                        nameValue0 = (this.bytes[this.offset] << 24) + (this.bytes[this.offset + 1] << 16) + (this.bytes[this.offset + 2] << 8) + this.bytes[this.offset + 3];
                        nameValue1 = ((long)this.bytes[this.offset + 4] << 56) + ((long)this.bytes[this.offset + 5] << 48) + ((long)this.bytes[this.offset + 6] << 40) + ((long)this.bytes[this.offset + 7] << 32) + ((long)this.bytes[this.offset + 8] << 24) + ((long)this.bytes[this.offset + 9] << 16) + ((long)this.bytes[this.offset + 10] << 8) + (long)this.bytes[this.offset + 11];
                        break;
                    }
                    case 13: {
                        nameValue0 = ((long)this.bytes[this.offset] << 32) + ((long)this.bytes[this.offset + 1] << 24) + ((long)this.bytes[this.offset + 2] << 16) + ((long)this.bytes[this.offset + 3] << 8) + (long)this.bytes[this.offset + 4];
                        nameValue1 = ((long)this.bytes[this.offset + 5] << 56) + ((long)this.bytes[this.offset + 6] << 48) + ((long)this.bytes[this.offset + 7] << 40) + ((long)this.bytes[this.offset + 8] << 32) + ((long)this.bytes[this.offset + 9] << 24) + ((long)this.bytes[this.offset + 10] << 16) + ((long)this.bytes[this.offset + 11] << 8) + (long)this.bytes[this.offset + 12];
                        break;
                    }
                    case 14: {
                        nameValue0 = ((long)this.bytes[this.offset] << 40) + ((long)this.bytes[this.offset + 1] << 32) + ((long)this.bytes[this.offset + 2] << 24) + ((long)this.bytes[this.offset + 3] << 16) + ((long)this.bytes[this.offset + 4] << 8) + (long)this.bytes[this.offset + 5];
                        nameValue1 = ((long)this.bytes[this.offset + 6] << 56) + ((long)this.bytes[this.offset + 7] << 48) + ((long)this.bytes[this.offset + 8] << 40) + ((long)this.bytes[this.offset + 9] << 32) + ((long)this.bytes[this.offset + 10] << 24) + ((long)this.bytes[this.offset + 11] << 16) + ((long)this.bytes[this.offset + 12] << 8) + (long)this.bytes[this.offset + 13];
                        break;
                    }
                    case 15: {
                        nameValue0 = ((long)this.bytes[this.offset] << 48) + ((long)this.bytes[this.offset + 1] << 40) + ((long)this.bytes[this.offset + 2] << 32) + ((long)this.bytes[this.offset + 3] << 24) + ((long)this.bytes[this.offset + 4] << 16) + ((long)this.bytes[this.offset + 5] << 8) + (long)this.bytes[this.offset + 6];
                        nameValue1 = ((long)this.bytes[this.offset + 7] << 56) + ((long)this.bytes[this.offset + 8] << 48) + ((long)this.bytes[this.offset + 9] << 40) + ((long)this.bytes[this.offset + 10] << 32) + ((long)this.bytes[this.offset + 11] << 24) + ((long)this.bytes[this.offset + 12] << 16) + ((long)this.bytes[this.offset + 13] << 8) + (long)this.bytes[this.offset + 14];
                        break;
                    }
                    case 16: {
                        nameValue0 = ((long)this.bytes[this.offset] << 56) + ((long)this.bytes[this.offset + 1] << 48) + ((long)this.bytes[this.offset + 2] << 40) + ((long)this.bytes[this.offset + 3] << 32) + ((long)this.bytes[this.offset + 4] << 24) + ((long)this.bytes[this.offset + 5] << 16) + ((long)this.bytes[this.offset + 6] << 8) + (long)this.bytes[this.offset + 7];
                        nameValue1 = ((long)this.bytes[this.offset + 8] << 56) + ((long)this.bytes[this.offset + 9] << 48) + ((long)this.bytes[this.offset + 10] << 40) + ((long)this.bytes[this.offset + 11] << 32) + ((long)this.bytes[this.offset + 12] << 24) + ((long)this.bytes[this.offset + 13] << 16) + ((long)this.bytes[this.offset + 14] << 8) + (long)this.bytes[this.offset + 15];
                        break;
                    }
                }
            }
            if (nameValue0 != -1L) {
                if (nameValue1 != -1L) {
                    int indexMask = (int)nameValue1 & JSONFactory.NAME_CACHE2.length - 1;
                    JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        String name = new String(this.bytes, this.offset, this.strlen, StandardCharsets.US_ASCII);
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, nameValue0, nameValue1);
                        this.offset += this.strlen;
                        return name;
                    }
                    if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                        this.offset += this.strlen;
                        return entry.name;
                    }
                } else {
                    int indexMask = (int)nameValue0 & JSONFactory.NAME_CACHE.length - 1;
                    JSONFactory.NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        String name = new String(this.bytes, this.offset, this.strlen, StandardCharsets.US_ASCII);
                        JSONFactory.NAME_CACHE[indexMask] = new JSONFactory.NameCacheEntry(name, nameValue0);
                        this.offset += this.strlen;
                        return name;
                    }
                    if (entry.value == nameValue0) {
                        this.offset += this.strlen;
                        return entry.name;
                    }
                }
            }
            charset = StandardCharsets.US_ASCII;
        } else if (this.strtype == 122) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_8;
        } else if (this.strtype == 123) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16;
        } else if (this.strtype == 124) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16LE;
        } else if (this.strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16BE;
        }
        if (this.strlen < 0) {
            str = this.symbolTable.getName(-this.strlen);
        }
        if (str == null) {
            str = new String(this.bytes, this.offset, this.strlen, charset);
            this.offset += this.strlen;
        }
        if (typeSymbol) {
            long strInfo;
            int symbol = this.readInt32Value();
            int minCapacity = symbol * 2 + 2;
            if (this.symbols.length < minCapacity) {
                this.symbols = Arrays.copyOf(this.symbols, this.symbols.length + 16);
            }
            this.symbols[symbol * 2 + 1] = strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)this.strtype;
        }
        return str;
    }

    @Override
    public String getFieldName() {
        return this.getString();
    }

    @Override
    public String readString() {
        Charset charset;
        this.strtype = this.bytes[this.offset++];
        if (this.strtype == -81) {
            return null;
        }
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 121) {
            if (this.strtype == 121) {
                this.strlen = this.readLength();
                this.strBegin = this.offset;
            } else {
                this.strlen = this.strtype - 73;
            }
            if (JDKUtils.JVM_VERSION == 8 && this.strlen >= 0) {
                char[] chars = new char[this.strlen];
                for (int i = 0; i < this.strlen; ++i) {
                    chars[i] = (char)this.bytes[this.offset + i];
                }
                this.offset += this.strlen;
                String str = new String(chars);
                if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                    str = str.trim();
                }
                return str;
            }
            charset = StandardCharsets.US_ASCII;
        } else if (this.strtype == 122) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_8;
        } else if (this.strtype == 123) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16;
        } else if (this.strtype == 124) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            if (this.strlen == 0) {
                return "";
            }
            charset = StandardCharsets.UTF_16LE;
        } else if (this.strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16BE;
        } else if (this.strtype == 126) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            if (GB18030 == null) {
                GB18030 = Charset.forName("GB18030");
            }
            charset = GB18030;
        } else {
            if (this.strtype >= -16 && this.strtype <= 47) {
                return Byte.toString(this.strtype);
            }
            if (this.strtype >= 48 && this.strtype <= 63) {
                int intValue = (this.strtype - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
                return Integer.toString(intValue);
            }
            if (this.strtype >= 64 && this.strtype <= 71) {
                int intValue = (this.strtype - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
                return Integer.toString(intValue);
            }
            if (this.strtype >= -40 && this.strtype <= -17) {
                int intValue = -8 + (this.strtype - -40);
                return Integer.toString(intValue);
            }
            if (this.strtype >= -56 && this.strtype <= -41) {
                int intValue = (this.strtype - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
                return Integer.toString(intValue);
            }
            if (this.strtype >= -64 && this.strtype <= -57) {
                int intValue = (this.strtype - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
                return Integer.toString(intValue);
            }
            switch (this.strtype) {
                case -81: {
                    return null;
                }
                case -78: {
                    return "0.0";
                }
                case -77: {
                    return "1.0";
                }
                case -65: 
                case 72: {
                    long int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                    this.offset += 4;
                    return Long.toString(int32Value);
                }
                case -74: {
                    return Float.toString(this.readInt32Value());
                }
                case -73: {
                    int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                    this.offset += 4;
                    float floatValue = Float.intBitsToFloat(int32Value);
                    return Float.toString(floatValue);
                }
                case -75: {
                    long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                    this.offset += 8;
                    double doubleValue = Double.longBitsToDouble(int64Value);
                    return Double.toString(doubleValue);
                }
                case -84: {
                    long int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                    this.offset += 4;
                    return Long.toString(int32Value * 1000L);
                }
                case -83: {
                    long minutes = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                    this.offset += 4;
                    return Long.toString(minutes * 60L * 1000L);
                }
                case -85: 
                case -66: {
                    long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                    this.offset += 8;
                    return Long.toString(int64Value);
                }
                case -69: {
                    int len = this.readInt32Value();
                    byte[] bytes = new byte[len];
                    System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                    this.offset += len;
                    return new BigInteger(bytes).toString();
                }
                case -71: {
                    int scale = this.readInt32Value();
                    BigInteger unscaledValue = this.readBigInteger();
                    BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                    return decimal.toString();
                }
                case -110: {
                    Object typedAny = this.readAny();
                    return typedAny == null ? null : typedAny.toString();
                }
                case -72: 
                case -70: {
                    return Long.toString(this.readInt64Value());
                }
                case -76: {
                    double doubleValue = this.readInt64Value();
                    return Double.toString(doubleValue);
                }
            }
            throw new JSONException("readString not support type " + JSONB.typeName(this.strtype) + ", offset " + this.offset + "/" + this.bytes.length);
        }
        if (this.strlen < 0) {
            return this.symbolTable.getName(-this.strlen);
        }
        String str = new String(this.bytes, this.offset, this.strlen, charset);
        this.offset += this.strlen;
        if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
            str = str.trim();
        }
        return str;
    }

    @Override
    public char readCharValue() {
        byte type = this.bytes[this.offset];
        if (type == -112) {
            ++this.offset;
            return (char)this.readInt32Value();
        }
        if (type >= 73 && type < 120) {
            ++this.offset;
            return (char)this.bytes[this.offset++];
        }
        String str = this.readString();
        if (str == null || str.isEmpty()) {
            this.wasNull = true;
            return '\u0000';
        }
        return str.charAt(0);
    }

    @Override
    public long readInt64Value() {
        byte type;
        this.wasNull = false;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return type;
        }
        if (type >= -40 && type <= -17) {
            return -8L + (long)(type - -40);
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        switch (type) {
            case -81: {
                this.wasNull = true;
                return 0L;
            }
            case -80: 
            case -78: {
                return 0L;
            }
            case -79: 
            case -77: {
                return 1L;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return int32Value;
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return (long)floatValue;
            }
            case -75: {
                --this.offset;
                return (long)this.readDoubleValue();
            }
            case -74: {
                return (long)((float)this.readInt32Value());
            }
            case -76: {
                return (long)((double)this.readInt64Value());
            }
            case -83: {
                long minutes = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return minutes * 60L * 1000L;
            }
            case -84: {
                long seconds = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return seconds * 1000L;
            }
            case -85: 
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return int64Value;
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.longValue();
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).longValue();
            }
            return new BigDecimal(str).longValue();
        }
        throw new JSONException("readInt64Value not support " + JSONB.typeName(type) + ", offset " + this.offset + "/" + this.bytes.length);
    }

    @Override
    public int readInt32Value() {
        byte type;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -40 && type <= -17) {
            return -8 + (type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        switch (type) {
            case -81: {
                this.wasNull = true;
                return 0;
            }
            case -80: 
            case -78: {
                return 0;
            }
            case -79: 
            case -77: {
                return 1;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -76: {
                return (int)this.readInt64Value();
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return (int)int64Value;
            }
            case -74: {
                return (int)((float)this.readInt32Value());
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return (int)floatValue;
            }
            case -75: {
                --this.offset;
                return (int)this.readDoubleValue();
            }
            case -84: 
            case -83: 
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return int32Value;
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return new BigDecimal(str).intValue();
        }
        throw new JSONException("readInt32Value not support " + JSONB.typeName(type) + ", offset " + this.offset + "/" + this.bytes.length);
    }

    @Override
    public boolean isBinary() {
        return this.bytes[this.offset] == -111;
    }

    @Override
    public byte[] readBinary() {
        byte type;
        if ((type = this.bytes[this.offset++]) != -111) {
            throw new JSONException("not support input : " + JSONB.typeName(type));
        }
        int len = this.readLength();
        byte[] bytes = new byte[len];
        System.arraycopy(this.bytes, this.offset, bytes, 0, len);
        this.offset += len;
        return bytes;
    }

    @Override
    public Integer readInt32() {
        this.wasNull = false;
        int value = this.readInt32Value();
        if (this.wasNull) {
            return null;
        }
        return value;
    }

    @Override
    public Long readInt64() {
        long value = this.readInt64Value();
        if (this.wasNull) {
            return null;
        }
        return value;
    }

    @Override
    public float readFloatValue() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                this.wasNull = true;
                return 0.0f;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return int64Value;
            }
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return int32Value;
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return Float.intBitsToFloat(int32Value);
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return (float)Double.longBitsToDouble(int64Value);
            }
            case -74: {
                return this.readInt32Value();
            }
            case -76: {
                return (float)((double)this.readInt64Value());
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
            case -80: 
            case -78: {
                return 0.0f;
            }
            case -79: 
            case -77: {
                return 1.0f;
            }
        }
        if (type >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -40 && type <= -17) {
            return -8 + (type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return new BigDecimal(str).intValue();
        }
        throw new JSONException("TODO : " + JSONB.typeName(type));
    }

    @Override
    public double readDoubleValue() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                this.wasNull = true;
                return 0.0;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return int64Value;
            }
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return int32Value;
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return Float.intBitsToFloat(int32Value);
            }
            case -74: {
                return this.readInt32Value();
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return Double.longBitsToDouble(int64Value);
            }
            case -76: {
                return this.readInt64Value();
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return new BigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
            case -80: 
            case -78: {
                return 0.0;
            }
            case -79: 
            case -77: {
                return 1.0;
            }
        }
        if (type >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -40 && type <= -17) {
            return -8L + (long)(type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return new BigDecimal(str).intValue();
        }
        throw new JSONException("TODO : " + JSONB.typeName(type));
    }

    @Override
    protected void readNumber0() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public Number readNumber() {
        byte type;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return (int)type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            return (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -40 && type <= -17) {
            return -8L + (long)(type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return 0.0;
            }
            case -79: 
            case -77: {
                return 1.0;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return (short)int16Value;
            }
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return int32Value;
            }
            case -65: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return (long)int32Value;
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return int64Value;
            }
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return Float.valueOf(Float.intBitsToFloat(int32Value));
            }
            case -74: {
                return Float.valueOf(this.readInt32Value());
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return Double.longBitsToDouble(int64Value);
            }
            case -76: {
                return (double)this.readInt64Value();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                if (scale == 0) {
                    return new BigDecimal(unscaledValue);
                }
                return new BigDecimal(unscaledValue, scale);
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                return new BigDecimal(str);
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                return new BigDecimal(str);
            }
            case -110: {
                String typeName = this.readString();
                throw new JSONException("not support input type : " + typeName);
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
            this.offset += strlen;
            return new BigDecimal(str);
        }
        throw new JSONException("not support type :" + JSONB.typeName(type));
    }

    @Override
    public BigDecimal readBigDecimal() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return BigDecimal.ZERO;
            }
            case -79: 
            case -77: {
                return BigDecimal.ONE;
            }
            case -67: {
                return BigDecimal.valueOf(this.bytes[this.offset++]);
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return BigDecimal.valueOf(int16Value);
            }
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return BigDecimal.valueOf(int32Value);
            }
            case -74: {
                float floatValue = this.readInt32Value();
                return BigDecimal.valueOf((long)floatValue);
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return BigDecimal.valueOf((long)floatValue);
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                double doubleValue = Double.longBitsToDouble(int64Value);
                return BigDecimal.valueOf((long)doubleValue);
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return BigDecimal.valueOf(int64Value);
            }
            case -69: {
                return new BigDecimal(this.readBigInteger());
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                if (scale == 0) {
                    return new BigDecimal(unscaledValue);
                }
                return new BigDecimal(unscaledValue, scale);
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case -76: {
                double doubleValue = this.readInt64Value();
                return BigDecimal.valueOf((long)doubleValue);
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                return new BigDecimal(str);
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                return new BigDecimal(str);
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                return new BigDecimal(str);
            }
        }
        if (type >= -16 && type <= 47) {
            return BigDecimal.valueOf(type);
        }
        if (type >= 48 && type <= 63) {
            int intValue = (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= 64 && type <= 71) {
            int intValue = (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= -40 && type <= -17) {
            int intValue = -8 + (type - -40);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= -56 && type <= -41) {
            int intValue = (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= -64 && type <= -57) {
            int intValue = (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
            this.offset += strlen;
            return new BigDecimal(str);
        }
        throw new JSONException("not support type :" + JSONB.typeName(type));
    }

    @Override
    public BigInteger readBigInteger() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return BigInteger.ZERO;
            }
            case -79: 
            case -77: {
                return BigInteger.ONE;
            }
            case -67: {
                return BigInteger.valueOf(this.bytes[this.offset++]);
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return BigInteger.valueOf(int16Value);
            }
            case -65: 
            case 72: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                return BigInteger.valueOf(int32Value);
            }
            case -74: {
                float floatValue = this.readInt32Value();
                return BigInteger.valueOf((long)floatValue);
            }
            case -73: {
                int int32Value = (this.bytes[this.offset + 3] & 0xFF) + ((this.bytes[this.offset + 2] & 0xFF) << 8) + ((this.bytes[this.offset + 1] & 0xFF) << 16) + (this.bytes[this.offset] << 24);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return BigInteger.valueOf((long)floatValue);
            }
            case -75: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                double doubleValue = Double.longBitsToDouble(int64Value);
                return BigInteger.valueOf((long)doubleValue);
            }
            case -66: {
                long int64Value = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return BigInteger.valueOf(int64Value);
            }
            case -111: 
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.toBigInteger();
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -76: {
                double doubleValue = this.readInt64Value();
                return BigInteger.valueOf((long)doubleValue);
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return new BigDecimal(str).toBigInteger();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return new BigDecimal(str).toBigInteger();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return new BigDecimal(str).toBigInteger();
            }
        }
        if (type >= -16 && type <= 47) {
            return BigInteger.valueOf(type);
        }
        if (type >= 48 && type <= 63) {
            int intValue = (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= 64 && type <= 71) {
            int intValue = (type - 68 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= -40 && type <= -17) {
            int intValue = -8 + (type - -40);
            return BigInteger.valueOf(intValue);
        }
        if (type >= -56 && type <= -41) {
            int intValue = (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= -64 && type <= -57) {
            int intValue = (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = new String(this.bytes, this.offset, strlen, StandardCharsets.US_ASCII);
            this.offset += strlen;
            return new BigInteger(str);
        }
        throw new JSONException("not support type :" + JSONB.typeName(type));
    }

    @Override
    public LocalDate readLocalDate() {
        byte type = this.bytes[this.offset];
        if (type == -87) {
            ++this.offset;
            int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            byte month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            return LocalDate.of(year, month, (int)dayOfMonth);
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    return this.readLocalDate8();
                }
                case 9: {
                    return this.readLocalDate9();
                }
                case 10: {
                    return this.readLocalDate10();
                }
                case 11: {
                    return this.readLocalDate11();
                }
            }
            throw new JSONException("TODO : " + len + ", " + this.readString());
        }
        if (type == 122 || type == 121) {
            this.strtype = type;
            ++this.offset;
            this.strlen = this.readLength();
            switch (this.strlen) {
                case 8: {
                    return this.readLocalDate8();
                }
                case 9: {
                    return this.readLocalDate9();
                }
                case 10: {
                    return this.readLocalDate10();
                }
                case 11: {
                    return this.readLocalDate11();
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        byte type = this.bytes[this.offset];
        if (type == -88) {
            ++this.offset;
            int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            byte month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            byte hour = this.bytes[this.offset++];
            byte minute = this.bytes[this.offset++];
            byte second = this.bytes[this.offset++];
            int nano = this.readInt32Value();
            return LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 16: {
                    return this.readLocalDateTime16();
                }
                case 17: {
                    return this.readLocalDateTime17();
                }
                case 18: {
                    return this.readLocalDateTime18();
                }
                case 19: {
                    return this.readLocalDateTime19();
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    LocalDateTime ldt = this.readLocalDateTimeX(len);
                    if (ldt != null) {
                        return ldt;
                    }
                    ZonedDateTime zdt = this.readZonedDateTimeX(len);
                    if (zdt == null) break;
                    return zdt.toLocalDateTime();
                }
            }
            throw new JSONException("TODO : " + len + ", " + this.readString());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected LocalDateTime readLocalDateTime16() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    protected LocalDateTime readLocalDateTime17() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    protected LocalTime readLocalTime10() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    protected LocalTime readLocalTime11() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    protected LocalDate readLocalDate11() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    protected ZonedDateTime readZonedDateTimeX(int len) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void skipLineComment() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public LocalTime readLocalTime() {
        byte type = this.bytes[this.offset];
        if (type == -89) {
            ++this.offset;
            byte hour = this.bytes[this.offset++];
            byte minute = this.bytes[this.offset++];
            byte second = this.bytes[this.offset++];
            int nano = this.readInt32Value();
            return LocalTime.of(hour, minute, second, nano);
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    return this.readLocalTime8();
                }
                case 10: {
                    return this.readLocalTime10();
                }
                case 11: {
                    return this.readLocalTime11();
                }
                case 12: {
                    return this.readLocalTime12();
                }
                case 18: {
                    return this.readLocalTime18();
                }
            }
            throw new JSONException("not support len : " + len);
        }
        if (type == 122 || type == 121) {
            this.strtype = type;
            ++this.offset;
            this.strlen = this.readLength();
            switch (this.strlen) {
                case 8: {
                    return this.readLocalTime8();
                }
                case 10: {
                    return this.readLocalTime10();
                }
                case 11: {
                    return this.readLocalTime11();
                }
                case 12: {
                    return this.readLocalTime12();
                }
                case 18: {
                    return this.readLocalTime18();
                }
            }
            throw new JSONException("not support len : " + this.strlen);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Instant readInstant() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -82: {
                long second = this.readInt64Value();
                int nano = this.readInt32Value();
                return Instant.ofEpochSecond(second, nano);
            }
            case -83: {
                long second = this.readInt32Value() * 60;
                return Instant.ofEpochSecond(second, 0L);
            }
            case -84: {
                long second = this.readInt32Value();
                return Instant.ofEpochSecond(second, 0L);
            }
            case -85: 
            case -66: {
                long millis = this.readInt64Value();
                return Instant.ofEpochMilli(millis);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ZonedDateTime readZonedDateTime() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -82: {
                long second = this.readInt64Value();
                int nano = this.readInt32Value();
                Instant instant = Instant.ofEpochSecond(second, nano);
                return ZonedDateTime.ofInstant(instant, UTC);
            }
            case -83: {
                long second = this.readInt32Value() * 60;
                Instant instant = Instant.ofEpochSecond(second);
                return ZonedDateTime.ofInstant(instant, UTC);
            }
            case -84: {
                long second = this.readInt32Value();
                Instant instant = Instant.ofEpochSecond(second);
                return ZonedDateTime.ofInstant(instant, UTC);
            }
            case -85: 
            case -66: {
                long millis = this.readInt64Value();
                Instant instant = Instant.ofEpochMilli(millis);
                return ZonedDateTime.ofInstant(instant, UTC);
            }
            case -86: {
                int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
                byte month = this.bytes[this.offset++];
                byte dayOfMonth = this.bytes[this.offset++];
                byte hour = this.bytes[this.offset++];
                byte minute = this.bytes[this.offset++];
                byte second = this.bytes[this.offset++];
                int nano = this.readInt32Value();
                LocalDateTime ldt = LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
                String zoneId = this.readString();
                return ZonedDateTime.of(ldt, ZoneId.of(zoneId));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public UUID readUUID() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                return null;
            }
            case -111: {
                int len = this.readLength();
                if (len != 16) {
                    throw new JSONException("uuid not support " + len);
                }
                long msb = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                long lsb = ((long)this.bytes[this.offset + 7] & 0xFFL) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 48) + ((long)this.bytes[this.offset] << 56);
                this.offset += 8;
                return new UUID(msb, lsb);
            }
            case 105: {
                long msb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 0);
                long msb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 4);
                long msb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 8);
                long msb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 12);
                long lsb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 16);
                long lsb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 20);
                long lsb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 24);
                long lsb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 28);
                if ((msb1 | msb2 | msb3 | msb4 | lsb1 | lsb2 | lsb3 | lsb4) >= 0L) {
                    this.offset += 32;
                    return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
                }
                throw new JSONException("Invalid UUID string:  " + new String(this.bytes, this.offset, 32, StandardCharsets.US_ASCII));
            }
            case 109: {
                long lsb4;
                long lsb3;
                long lsb2;
                long lsb1;
                long msb4;
                long msb3;
                long msb2;
                long msb1;
                byte ch1 = this.bytes[this.offset + 8];
                byte ch2 = this.bytes[this.offset + 13];
                byte ch3 = this.bytes[this.offset + 18];
                byte ch4 = this.bytes[this.offset + 23];
                if (ch1 == 45 && ch2 == 45 && ch3 == 45 && ch4 == 45 && ((msb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 0)) | (msb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 9)) | (msb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 14)) | (lsb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 19)) | (lsb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 24)) | (lsb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 28)) | (lsb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 32))) >= 0L) {
                    this.offset += 36;
                    return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
                }
                throw new JSONException("Invalid UUID string:  " + new String(this.bytes, this.offset, 36, StandardCharsets.US_ASCII));
            }
            case 121: 
            case 122: {
                int strlen = this.readLength();
                if (strlen == 32) {
                    long lsb4;
                    long lsb3;
                    long lsb2;
                    long lsb1;
                    long msb4;
                    long msb3;
                    long msb2;
                    long msb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 0);
                    if ((msb1 | (msb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 8)) | (msb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 12)) | (lsb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 16)) | (lsb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 20)) | (lsb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 24)) | (lsb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 28))) >= 0L) {
                        this.offset += 32;
                        return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
                    }
                } else if (strlen == 36) {
                    long lsb4;
                    long lsb3;
                    long lsb2;
                    long lsb1;
                    long msb4;
                    long msb3;
                    long msb2;
                    long msb1;
                    byte ch1 = this.bytes[this.offset + 8];
                    byte ch2 = this.bytes[this.offset + 13];
                    byte ch3 = this.bytes[this.offset + 18];
                    byte ch4 = this.bytes[this.offset + 23];
                    if (ch1 == 45 && ch2 == 45 && ch3 == 45 && ch4 == 45 && ((msb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 0)) | (msb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 9)) | (msb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 14)) | (lsb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 19)) | (lsb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 24)) | (lsb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 28)) | (lsb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 32))) >= 0L) {
                        this.offset += 36;
                        return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
                    }
                }
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                throw new JSONException("Invalid UUID string:  " + str);
            }
        }
        throw new JSONException("type not support : " + JSONB.typeName(type));
    }

    @Override
    public boolean readBoolValue() {
        this.wasNull = false;
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -79: 
            case 1: {
                return true;
            }
            case -80: 
            case 0: {
                return false;
            }
            case -81: {
                this.wasNull = true;
                return false;
            }
            case 74: {
                if (this.bytes[this.offset] == 49 || this.bytes[this.offset] == 89) {
                    ++this.offset;
                    return true;
                }
                if (this.bytes[this.offset] == 48 || this.bytes[this.offset] == 78) {
                    ++this.offset;
                    return false;
                }
            }
            case 77: {
                if (this.bytes[this.offset] == 116 && this.bytes[this.offset + 1] == 114 && this.bytes[this.offset + 2] == 117 && this.bytes[this.offset + 3] == 101) {
                    this.offset += 4;
                    return true;
                }
                if (this.bytes[this.offset] == 84 && this.bytes[this.offset + 1] == 82 && this.bytes[this.offset + 2] == 85 && this.bytes[this.offset + 3] == 69) {
                    this.offset += 4;
                    return true;
                }
            }
            case 78: {
                if (this.bytes[this.offset] == 102 && this.bytes[this.offset + 1] == 97 && this.bytes[this.offset + 2] == 108 && this.bytes[this.offset + 3] == 115 && this.bytes[this.offset + 4] == 101) {
                    this.offset += 5;
                    return false;
                }
                if (this.bytes[this.offset] == 70 && this.bytes[this.offset + 1] == 65 && this.bytes[this.offset + 2] == 76 && this.bytes[this.offset + 3] == 83 && this.bytes[this.offset + 4] == 69) {
                    this.offset += 5;
                    return false;
                }
            }
            case 121: {
                this.strlen = this.readLength();
                if (this.strlen == 1) {
                    if (this.bytes[this.offset] == 89) {
                        ++this.offset;
                        return true;
                    }
                    if (this.bytes[this.offset] == 78) {
                        ++this.offset;
                        return true;
                    }
                } else {
                    if (this.strlen == 4 && this.bytes[this.offset] == 116 && this.bytes[this.offset + 1] == 114 && this.bytes[this.offset + 2] == 117 && this.bytes[this.offset + 3] == 101) {
                        this.offset += 4;
                        return true;
                    }
                    if (this.strlen == 5) {
                        if (this.bytes[this.offset] == 102 && this.bytes[this.offset + 1] == 97 && this.bytes[this.offset + 2] == 108 && this.bytes[this.offset + 3] == 115 && this.bytes[this.offset + 4] == 101) {
                            this.offset += 5;
                            return false;
                        }
                        if (this.bytes[this.offset] == 70 && this.bytes[this.offset + 1] == 65 && this.bytes[this.offset + 2] == 76 && this.bytes[this.offset + 3] == 83 && this.bytes[this.offset + 4] == 69) {
                            this.offset += 5;
                            return false;
                        }
                    }
                }
                String str = new String(this.bytes, this.offset, this.strlen, StandardCharsets.US_ASCII);
                this.offset += this.strlen;
                throw new JSONException("not support input " + str);
            }
            case 124: {
                this.strlen = this.readLength();
                String str = new String(this.bytes, this.offset, this.strlen, StandardCharsets.UTF_16LE);
                this.offset += this.strlen;
                switch (str) {
                    case "0": 
                    case "N": {
                        return false;
                    }
                    case "1": 
                    case "Y": {
                        return true;
                    }
                }
                throw new JSONException("not support input " + str);
            }
        }
        throw new JSONException("not support type : " + JSONB.typeName(type));
    }

    @Override
    public boolean nextIfMatch(byte type) {
        if (this.bytes[this.offset] == type) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    protected int getStringLength() {
        this.type = this.bytes[this.offset];
        if (this.type >= 73 && this.type < 120) {
            return this.type - 73;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalDate readLocalDate8() {
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        this.type = this.bytes[this.offset];
        if (this.type != 81) {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 1];
        byte c1 = this.bytes[this.offset + 2];
        byte c2 = this.bytes[this.offset + 3];
        byte c3 = this.bytes[this.offset + 4];
        byte c4 = this.bytes[this.offset + 5];
        byte c5 = this.bytes[this.offset + 6];
        byte c6 = this.bytes[this.offset + 7];
        byte c7 = this.bytes[this.offset + 8];
        if (c4 == 45 && c6 == 45) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = 48;
            m1 = (char)c5;
            d0 = 48;
            d1 = (char)c7;
        } else {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = c4;
            m1 = (char)c5;
            d0 = c6;
            d1 = (char)c7;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDate ldt = LocalDate.of(year, month, dom);
        this.offset += 9;
        return ldt;
    }

    @Override
    public LocalDate readLocalDate9() {
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        this.type = this.bytes[this.offset];
        if (this.type != 82) {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 1];
        byte c1 = this.bytes[this.offset + 2];
        byte c2 = this.bytes[this.offset + 3];
        byte c3 = this.bytes[this.offset + 4];
        byte c4 = this.bytes[this.offset + 5];
        byte c5 = this.bytes[this.offset + 6];
        byte c6 = this.bytes[this.offset + 7];
        byte c7 = this.bytes[this.offset + 8];
        byte c8 = this.bytes[this.offset + 9];
        if (c4 == 45 && c6 == 45) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = 48;
            m1 = (char)c5;
            d0 = c7;
            d1 = (char)c8;
        } else if (c4 == 45 && c7 == 45) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = (char)c5;
            m1 = (char)c6;
            d0 = 48;
            d1 = (char)c8;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDate ldt = LocalDate.of(year, month, dom);
        this.offset += 10;
        return ldt;
    }

    @Override
    protected LocalDate readLocalDate10() {
        byte d1;
        byte d0;
        byte m1;
        byte m0;
        byte y3;
        byte y2;
        byte y1;
        byte y0;
        byte c9;
        byte c8;
        byte c7;
        byte c6;
        byte c5;
        byte c4;
        byte c3;
        byte c2;
        byte c1;
        byte c0;
        if (this.bytes[this.offset] == 83) {
            c0 = this.bytes[this.offset + 1];
            c1 = this.bytes[this.offset + 2];
            c2 = this.bytes[this.offset + 3];
            c3 = this.bytes[this.offset + 4];
            c4 = this.bytes[this.offset + 5];
            c5 = this.bytes[this.offset + 6];
            c6 = this.bytes[this.offset + 7];
            c7 = this.bytes[this.offset + 8];
            c8 = this.bytes[this.offset + 9];
            c9 = this.bytes[this.offset + 10];
        } else if ((this.strtype == 122 || this.strtype == 121) && this.strlen == 10) {
            c0 = this.bytes[this.offset + 0];
            c1 = this.bytes[this.offset + 1];
            c2 = this.bytes[this.offset + 2];
            c3 = this.bytes[this.offset + 3];
            c4 = this.bytes[this.offset + 4];
            c5 = this.bytes[this.offset + 5];
            c6 = this.bytes[this.offset + 6];
            c7 = this.bytes[this.offset + 7];
            c8 = this.bytes[this.offset + 8];
            c9 = this.bytes[this.offset + 9];
        } else {
            throw new JSONException("date only support string input");
        }
        if (c4 == 45 && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == 47 && c7 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == 46 && c5 == 46) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 45 && c5 == 45) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        LocalDate ldt = LocalDate.of(year, month, dom);
        this.offset += 11;
        return ldt;
    }

    @Override
    protected LocalTime readLocalTime5() {
        this.type = this.bytes[this.offset];
        if (this.type != 78) {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 1];
        byte c1 = this.bytes[this.offset + 2];
        byte c2 = this.bytes[this.offset + 3];
        byte c3 = this.bytes[this.offset + 4];
        byte c4 = this.bytes[this.offset + 5];
        if (c2 != 58) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        this.offset += 6;
        return LocalTime.of(hour, minute);
    }

    @Override
    protected LocalTime readLocalTime8() {
        this.type = this.bytes[this.offset];
        if (this.type != 81) {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 1];
        byte c1 = this.bytes[this.offset + 2];
        byte c2 = this.bytes[this.offset + 3];
        byte c3 = this.bytes[this.offset + 4];
        byte c4 = this.bytes[this.offset + 5];
        byte c5 = this.bytes[this.offset + 6];
        byte c6 = this.bytes[this.offset + 7];
        byte c7 = this.bytes[this.offset + 8];
        if (c2 != 58 || c5 != 58) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        this.offset += 9;
        return LocalTime.of(hour, minute, seccond);
    }

    @Override
    protected LocalTime readLocalTime12() {
        byte c11;
        byte c10;
        byte c9;
        byte c8;
        byte c7;
        byte c6;
        byte c5;
        byte c4;
        byte c3;
        byte c2;
        byte c1;
        byte c0;
        if (this.bytes[this.offset] == 85) {
            c0 = this.bytes[this.offset + 1];
            c1 = this.bytes[this.offset + 2];
            c2 = this.bytes[this.offset + 3];
            c3 = this.bytes[this.offset + 4];
            c4 = this.bytes[this.offset + 5];
            c5 = this.bytes[this.offset + 6];
            c6 = this.bytes[this.offset + 7];
            c7 = this.bytes[this.offset + 8];
            c8 = this.bytes[this.offset + 9];
            c9 = this.bytes[this.offset + 10];
            c10 = this.bytes[this.offset + 11];
            c11 = this.bytes[this.offset + 12];
        } else if ((this.strtype == 122 || this.strtype == 121) && this.strlen == 12) {
            c0 = this.bytes[this.offset];
            c1 = this.bytes[this.offset + 1];
            c2 = this.bytes[this.offset + 2];
            c3 = this.bytes[this.offset + 3];
            c4 = this.bytes[this.offset + 4];
            c5 = this.bytes[this.offset + 5];
            c6 = this.bytes[this.offset + 6];
            c7 = this.bytes[this.offset + 7];
            c8 = this.bytes[this.offset + 8];
            c9 = this.bytes[this.offset + 9];
            c10 = this.bytes[this.offset + 10];
            c11 = this.bytes[this.offset + 11];
        } else {
            throw new JSONException("date only support string input");
        }
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        byte m1 = c10;
        byte m2 = c11;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57 || m2 < 48 || m2 > 57) {
            return null;
        }
        int millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
        this.offset += 13;
        return LocalTime.of(hour, minute, seccond, millis *= 1000000);
    }

    @Override
    protected LocalTime readLocalTime18() {
        byte c17;
        byte c16;
        byte c15;
        byte c14;
        byte c13;
        byte c12;
        byte c11;
        byte c10;
        byte c9;
        byte c8;
        byte c7;
        byte c6;
        byte c5;
        byte c4;
        byte c3;
        byte c2;
        byte c1;
        byte c0;
        if (this.bytes[this.offset] == 91) {
            c0 = this.bytes[this.offset + 1];
            c1 = this.bytes[this.offset + 2];
            c2 = this.bytes[this.offset + 3];
            c3 = this.bytes[this.offset + 4];
            c4 = this.bytes[this.offset + 5];
            c5 = this.bytes[this.offset + 6];
            c6 = this.bytes[this.offset + 7];
            c7 = this.bytes[this.offset + 8];
            c8 = this.bytes[this.offset + 9];
            c9 = this.bytes[this.offset + 10];
            c10 = this.bytes[this.offset + 11];
            c11 = this.bytes[this.offset + 12];
            c12 = this.bytes[this.offset + 13];
            c13 = this.bytes[this.offset + 14];
            c14 = this.bytes[this.offset + 15];
            c15 = this.bytes[this.offset + 16];
            c16 = this.bytes[this.offset + 17];
            c17 = this.bytes[this.offset + 18];
        } else if ((this.strtype == 122 || this.strtype == 121) && this.strlen == 18) {
            c0 = this.bytes[this.offset];
            c1 = this.bytes[this.offset + 1];
            c2 = this.bytes[this.offset + 2];
            c3 = this.bytes[this.offset + 3];
            c4 = this.bytes[this.offset + 4];
            c5 = this.bytes[this.offset + 5];
            c6 = this.bytes[this.offset + 6];
            c7 = this.bytes[this.offset + 7];
            c8 = this.bytes[this.offset + 8];
            c9 = this.bytes[this.offset + 9];
            c10 = this.bytes[this.offset + 10];
            c11 = this.bytes[this.offset + 11];
            c12 = this.bytes[this.offset + 12];
            c13 = this.bytes[this.offset + 13];
            c14 = this.bytes[this.offset + 14];
            c15 = this.bytes[this.offset + 15];
            c16 = this.bytes[this.offset + 16];
            c17 = this.bytes[this.offset + 17];
        } else {
            throw new JSONException("date only support string input");
        }
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        byte m1 = c10;
        byte m2 = c11;
        byte m3 = c12;
        byte m4 = c13;
        byte m5 = c14;
        byte m6 = c15;
        byte m7 = c16;
        byte m8 = c17;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57 || m2 < 48 || m2 > 57 || m3 < 48 || m3 > 57 || m4 < 48 || m4 > 57 || m5 < 48 || m5 > 57 || m6 < 48 || m6 > 57 || m7 < 48 || m7 > 57 || m8 < 48 || m8 > 57) {
            return null;
        }
        int millis = (m0 - 48) * 100000000 + (m1 - 48) * 10000000 + (m2 - 48) * 1000000 + (m3 - 48) * 100000 + (m4 - 48) * 10000 + (m5 - 48) * 1000 + (m6 - 48) * 100 + (m7 - 48) * 10 + (m8 - 48);
        this.offset += 19;
        return LocalTime.of(hour, minute, seccond, millis);
    }

    @Override
    protected LocalDateTime readLocalDateTime18() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public long readMillis19() {
        int S2;
        int S1;
        int S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        this.type = this.bytes[this.offset];
        if (this.type != 92) {
            throw new JSONException("date only support string input");
        }
        char c0 = (char)this.bytes[this.offset + 1];
        char c1 = (char)this.bytes[this.offset + 2];
        char c2 = (char)this.bytes[this.offset + 3];
        char c3 = (char)this.bytes[this.offset + 4];
        char c4 = (char)this.bytes[this.offset + 5];
        char c5 = (char)this.bytes[this.offset + 6];
        char c6 = (char)this.bytes[this.offset + 7];
        char c7 = (char)this.bytes[this.offset + 8];
        char c8 = (char)this.bytes[this.offset + 9];
        char c9 = (char)this.bytes[this.offset + 10];
        char c10 = (char)this.bytes[this.offset + 11];
        char c11 = (char)this.bytes[this.offset + 12];
        char c12 = (char)this.bytes[this.offset + 13];
        char c13 = (char)this.bytes[this.offset + 14];
        char c14 = (char)this.bytes[this.offset + 15];
        char c15 = (char)this.bytes[this.offset + 16];
        char c16 = (char)this.bytes[this.offset + 17];
        char c17 = (char)this.bytes[this.offset + 18];
        char c18 = (char)this.bytes[this.offset + 19];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else {
            this.wasNull = true;
            return 0L;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            this.wasNull = true;
            return 0L;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < 48 || S0 > 57 || S1 < 48 || S1 > 57 || S2 < 48 || S2 > 57) {
            this.wasNull = true;
            return 0L;
        }
        int nanoOfSecond = (S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48);
        this.offset += 20;
        return this.millis(year, month, dom, hour, minute, second, nanoOfSecond *= 1000000);
    }

    @Override
    protected LocalDateTime readLocalDateTime19() {
        int S2;
        int S1;
        int S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        this.type = this.bytes[this.offset];
        if (this.type != 92) {
            throw new JSONException("date only support string input");
        }
        char c0 = (char)this.bytes[this.offset + 1];
        char c1 = (char)this.bytes[this.offset + 2];
        char c2 = (char)this.bytes[this.offset + 3];
        char c3 = (char)this.bytes[this.offset + 4];
        char c4 = (char)this.bytes[this.offset + 5];
        char c5 = (char)this.bytes[this.offset + 6];
        char c6 = (char)this.bytes[this.offset + 7];
        char c7 = (char)this.bytes[this.offset + 8];
        char c8 = (char)this.bytes[this.offset + 9];
        char c9 = (char)this.bytes[this.offset + 10];
        char c10 = (char)this.bytes[this.offset + 11];
        char c11 = (char)this.bytes[this.offset + 12];
        char c12 = (char)this.bytes[this.offset + 13];
        char c13 = (char)this.bytes[this.offset + 14];
        char c14 = (char)this.bytes[this.offset + 15];
        char c15 = (char)this.bytes[this.offset + 16];
        char c16 = (char)this.bytes[this.offset + 17];
        char c17 = (char)this.bytes[this.offset + 18];
        char c18 = (char)this.bytes[this.offset + 19];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < 48 || S0 > 57 || S1 < 48 || S1 > 57 || S2 < 48 || S2 > 57) {
            return null;
        }
        int millis = (S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second, millis *= 1000000);
        this.offset += 20;
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTimeX(int len) {
        byte c20;
        this.type = this.bytes[this.offset];
        if (this.type < 73 || this.type > 120) {
            throw new JSONException("date only support string input");
        }
        if (len < 21 || len > 29) {
            throw new JSONException("illeal localdatetime string : " + this.readString());
        }
        byte c0 = this.bytes[this.offset + 1];
        byte c1 = this.bytes[this.offset + 2];
        byte c2 = this.bytes[this.offset + 3];
        byte c3 = this.bytes[this.offset + 4];
        byte c4 = this.bytes[this.offset + 5];
        byte c5 = this.bytes[this.offset + 6];
        byte c6 = this.bytes[this.offset + 7];
        byte c7 = this.bytes[this.offset + 8];
        byte c8 = this.bytes[this.offset + 9];
        byte c9 = this.bytes[this.offset + 10];
        byte c10 = this.bytes[this.offset + 11];
        byte c11 = this.bytes[this.offset + 12];
        byte c12 = this.bytes[this.offset + 13];
        byte c13 = this.bytes[this.offset + 14];
        byte c14 = this.bytes[this.offset + 15];
        byte c15 = this.bytes[this.offset + 16];
        byte c16 = this.bytes[this.offset + 17];
        byte c17 = this.bytes[this.offset + 18];
        byte c18 = this.bytes[this.offset + 19];
        byte c19 = this.bytes[this.offset + 20];
        int c21 = 48;
        int c22 = 48;
        int c23 = 48;
        int c24 = 48;
        int c25 = 48;
        int c26 = 48;
        int c27 = 48;
        int c28 = 48;
        switch (len) {
            case 21: {
                c20 = this.bytes[this.offset + 21];
                break;
            }
            case 22: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                break;
            }
            case 23: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                break;
            }
            case 24: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                break;
            }
            case 25: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                c24 = this.bytes[this.offset + 25];
                break;
            }
            case 26: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                c24 = this.bytes[this.offset + 25];
                c25 = this.bytes[this.offset + 26];
                break;
            }
            case 27: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                c24 = this.bytes[this.offset + 25];
                c25 = this.bytes[this.offset + 26];
                c26 = this.bytes[this.offset + 27];
                break;
            }
            case 28: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                c24 = this.bytes[this.offset + 25];
                c25 = this.bytes[this.offset + 26];
                c26 = this.bytes[this.offset + 27];
                c27 = this.bytes[this.offset + 28];
                break;
            }
            default: {
                c20 = this.bytes[this.offset + 21];
                c21 = this.bytes[this.offset + 22];
                c22 = this.bytes[this.offset + 23];
                c23 = this.bytes[this.offset + 24];
                c24 = this.bytes[this.offset + 25];
                c25 = this.bytes[this.offset + 26];
                c26 = this.bytes[this.offset + 27];
                c27 = this.bytes[this.offset + 28];
                c28 = this.bytes[this.offset + 29];
            }
        }
        if (c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46) {
            return null;
        }
        char y0 = (char)c0;
        char y1 = (char)c1;
        char y2 = (char)c2;
        char y3 = (char)c3;
        char m0 = (char)c5;
        char m1 = (char)c6;
        char d0 = (char)c8;
        char d1 = (char)c9;
        char h0 = (char)c11;
        char h1 = (char)c12;
        char i0 = (char)c14;
        char i1 = (char)c15;
        char s0 = (char)c17;
        char s1 = (char)c18;
        char S0 = (char)c20;
        char S1 = (char)c21;
        char S2 = (char)c22;
        char S3 = (char)c23;
        char S4 = (char)c24;
        char S5 = (char)c25;
        char S6 = (char)c26;
        char S7 = (char)c27;
        char S8 = (char)c28;
        LocalDateTime ldt = JSONReaderUTF16.getLocalDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        return ldt;
    }

    @Override
    public String readPattern() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public long readFieldNameHashCodeUnquote() {
        return this.readFieldNameHashCode();
    }

    @Override
    public boolean nextIfSet() {
        return false;
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void close() {
        if (this.valueBytes != null) {
            JSONFactory.releaseByteArray(this.cachedIndex, this.valueBytes);
        }
    }
}

