/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.trove.map.hash;

import com.alibaba.fastjson2.trove.impl.PrimeFinder;
import com.alibaba.fastjson2.trove.procedure.TLongIntProcedure;

public class TLongIntHashMap {
    public static final int DEFAULT_ENTRY_VALUE = -1;
    static final byte FREE = 0;
    static final byte FULL = 1;
    protected int[] _values;
    protected long[] _set;
    protected boolean consumeFreeSlot;
    protected byte[] _states;
    protected int _size;
    protected int _free;
    protected int _maxSize;

    public TLongIntHashMap() {
        int capacity = 37;
        this._maxSize = 18;
        this._free = capacity;
        this._states = new byte[capacity];
        this._set = new long[capacity];
        this._values = new int[capacity];
    }

    public void put(long key, int value) {
        int hash = (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
        int index = hash % this._states.length;
        byte state = this._states[index];
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            this._set[index] = key;
            this._states[index] = 1;
        } else if (state == 1 && this._set[index] == key) {
            index = -index - 1;
        } else {
            int length = this._set.length;
            int probe = 1 + hash % (length - 2);
            int loopIndex = index;
            do {
                if ((index -= probe) < 0) {
                    index += length;
                }
                if ((state = this._states[index]) == 0) {
                    this.consumeFreeSlot = true;
                    this._set[index] = key;
                    this._states[index] = 1;
                    break;
                }
                if (state != 1 || this._set[index] != key) continue;
                index = -index - 1;
                break;
            } while (index != loopIndex);
        }
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            isNewMapping = false;
        }
        this._values[index] = value;
        if (isNewMapping) {
            if (this.consumeFreeSlot) {
                --this._free;
            }
            if (++this._size > this._maxSize || this._free == 0) {
                int capacity = this._states.length;
                int newCapacity = this._size > this._maxSize ? PrimeFinder.nextPrime(capacity << 1) : capacity;
                int oldCapacity = this._set.length;
                long[] oldKeys = this._set;
                int[] oldVals = this._values;
                byte[] oldStates = this._states;
                this._set = new long[newCapacity];
                this._values = new int[newCapacity];
                this._states = new byte[newCapacity];
                int i = oldCapacity;
                while (i-- > 0) {
                    if (oldStates[i] != 1) continue;
                    long o = oldKeys[i];
                    index = this.insertKey(o);
                    this._values[index] = oldVals[i];
                }
                capacity = this._states.length;
                this._maxSize = Math.min(capacity - 1, (int)((float)capacity * 0.5f));
                this._free = capacity - this._size;
            }
        }
    }

    public int get(long key) {
        int hash = (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
        int length = this._states.length;
        int index = hash % length;
        byte state = this._states[index];
        if (state == 0) {
            return -1;
        }
        if (state == 1 && this._set[index] == key) {
            return this._values[index];
        }
        int setLength = this._set.length;
        int probe = 1 + hash % (setLength - 2);
        int loopIndex = index;
        do {
            if ((index -= probe) < 0) {
                index += setLength;
            }
            if ((state = this._states[index]) == 0) {
                return -1;
            }
            if (key != this._set[index]) continue;
            return this._values[index];
        } while (index != loopIndex);
        return -1;
    }

    public boolean forEachEntry(TLongIntProcedure procedure) {
        byte[] states = this._states;
        long[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TLongIntProcedure(){
            private boolean first = true;

            @Override
            public boolean execute(long key, int value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    public int size() {
        return this._size;
    }

    protected int insertKey(long key) {
        int hash = (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
        int index = hash % this._states.length;
        byte state = this._states[index];
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            this._set[index] = key;
            this._states[index] = 1;
            return index;
        }
        if (state == 1 && this._set[index] == key) {
            return -index - 1;
        }
        int length = this._set.length;
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states[index]) == 0) {
                this.consumeFreeSlot = true;
                this._set[index] = key;
                this._states[index] = 1;
                return index;
            }
            if (state != 1 || this._set[index] != key) continue;
            return -index - 1;
        } while (index != loopIndex);
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }
}

