/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.ObjectArrayReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderCreatorASM;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplString;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;

public class ObjectReaderProvider {
    static final String[] DENYS;
    static final String[] AUTO_TYPE_ACCEPT_LIST;
    static AutoTypeBeforeHandler DEFAULT_AUTO_TYPE_BEFORE_HANDLER;
    static Consumer<Class> DEFAULT_AUTO_TYPE_HANDLER;
    static boolean DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR;
    final ConcurrentMap<Type, ObjectReader> cache = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Type, ObjectReader> cacheFieldBased = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Integer, ConcurrentHashMap<Long, ObjectReader>> tclHashCaches = new ConcurrentHashMap<Integer, ConcurrentHashMap<Long, ObjectReader>>();
    final ConcurrentMap<Long, ObjectReader> hashCache = new ConcurrentHashMap<Long, ObjectReader>();
    final ConcurrentMap<Class, Class> mixInCache = new ConcurrentHashMap<Class, Class>();
    private ConcurrentMap<Type, Map<Type, Function>> typeConverts = new ConcurrentHashMap<Type, Map<Type, Function>>();
    final ObjectReaderCreator creator;
    final List<ObjectReaderModule> modules = new ArrayList<ObjectReaderModule>();
    private long[] denyHashCodes;
    private long[] acceptHashCodes;
    private AutoTypeBeforeHandler autoTypeBeforeHandler = DEFAULT_AUTO_TYPE_BEFORE_HANDLER;
    private Consumer<Class> autoTypeHandler = DEFAULT_AUTO_TYPE_HANDLER;

    public void registerIfAbsent(long hashCode, ObjectReader objectReader) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != null && tcl != JSON.class.getClassLoader()) {
            int tclHash = System.identityHashCode(tcl);
            ConcurrentHashMap tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash);
            if (tclHashCache == null) {
                this.tclHashCaches.putIfAbsent(tclHash, new ConcurrentHashMap());
                tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash);
            }
            tclHashCache.putIfAbsent(hashCode, objectReader);
        }
        this.hashCache.putIfAbsent(hashCode, objectReader);
    }

    public Consumer<Class> getAutoTypeHandler() {
        return this.autoTypeHandler;
    }

    public void setAutoTypeHandler(Consumer<Class> autoTypeHandler) {
        this.autoTypeHandler = autoTypeHandler;
    }

    public Class getMixIn(Class target) {
        return (Class)this.mixInCache.get(target);
    }

    public void mixIn(Class target, Class mixinSource) {
        this.mixInCache.put(target, mixinSource);
        this.cache.remove(target);
        this.cacheFieldBased.remove(target);
    }

    public boolean register(Type type, ObjectReader objectReader) {
        return this.cache.put(type, objectReader) == null;
    }

    public ObjectReaderCreator getCreator() {
        ObjectReaderCreator contextCreator = JSONFactory.getContextReaderCreator();
        if (contextCreator != null) {
            return contextCreator;
        }
        return this.creator;
    }

    public ObjectReaderProvider() {
        this.denyHashCodes = new long[]{-8720046426850100497L, -8165637398350707645L, -8109300701639721088L, -8083514888460375884L, -7966123100503199569L, -7921218830998286408L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6179589609550493385L, -5194641081268104286L, -4837536971810737970L, -4082057040235125754L, -3935185854875733362L, -2753427844400776271L, -2364987994247679115L, -2262244760619952081L, -1872417015366588117L, -1589194880214235129L, -254670111376247151L, -190281065685395680L, 33238344207745342L, 313864100207897507L, 1073634739308289776L, 1203232727967308606L, 1459860845934817624L, 1502845958873959152L, 3547627781654598988L, 3730752432285826863L, 3794316665763266033L, 4147696707147271408L, 4904007817188630457L, 5347909877633654828L, 5450448828334921485L, 5688200883751798389L, 5751393439502795295L, 5944107969236155580L, 6742705432718011780L, 7017492163108594270L, 7179336928365889465L, 7442624256860549330L, 8389032537095247355L, 8838294710098435315L};
        long[] hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
        for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
            hashCodes[i] = Fnv.hashCode64(AUTO_TYPE_ACCEPT_LIST[i]);
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.hashCache.put(ObjectArrayReader.TYPE_HASH_CODE, ObjectArrayReader.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(String.class.getName()), ObjectReaderImplString.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(TypeUtils.getTypeName(HashMap.class)), ObjectReaderImplMap.INSTANCE);
        this.creator = ObjectReaderCreatorASM.INSTANCE;
        this.modules.add(new ObjectReaderBaseModule(this));
        this.init();
    }

    public ObjectReaderProvider(ObjectReaderCreator creator) {
        this.denyHashCodes = new long[]{-8720046426850100497L, -8165637398350707645L, -8109300701639721088L, -8083514888460375884L, -7966123100503199569L, -7921218830998286408L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6179589609550493385L, -5194641081268104286L, -4837536971810737970L, -4082057040235125754L, -3935185854875733362L, -2753427844400776271L, -2364987994247679115L, -2262244760619952081L, -1872417015366588117L, -1589194880214235129L, -254670111376247151L, -190281065685395680L, 33238344207745342L, 313864100207897507L, 1073634739308289776L, 1203232727967308606L, 1459860845934817624L, 1502845958873959152L, 3547627781654598988L, 3730752432285826863L, 3794316665763266033L, 4147696707147271408L, 4904007817188630457L, 5347909877633654828L, 5450448828334921485L, 5688200883751798389L, 5751393439502795295L, 5944107969236155580L, 6742705432718011780L, 7017492163108594270L, 7179336928365889465L, 7442624256860549330L, 8389032537095247355L, 8838294710098435315L};
        long[] hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
        for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
            hashCodes[i] = Fnv.hashCode64(AUTO_TYPE_ACCEPT_LIST[i]);
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.hashCache.put(ObjectArrayReader.TYPE_HASH_CODE, ObjectArrayReader.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(String.class.getName()), ObjectReaderImplString.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(TypeUtils.getTypeName(HashMap.class)), ObjectReaderImplMap.INSTANCE);
        this.creator = creator;
        this.modules.add(new ObjectReaderBaseModule(this));
        this.init();
    }

    void init() {
        for (ObjectReaderModule module : this.modules) {
            module.init(this);
        }
    }

    public Function getTypeConvert(Type from, Type to) {
        Map map = (Map)this.typeConverts.get(from);
        if (map == null) {
            return null;
        }
        return (Function)map.get(to);
    }

    public Function registerTypeConvert(Type from, Type to, Function typeConvert) {
        Map map = (Map)this.typeConverts.get(from);
        if (map == null) {
            this.typeConverts.putIfAbsent(from, new ConcurrentHashMap());
            map = (Map)this.typeConverts.get(from);
        }
        return map.putIfAbsent(to, typeConvert);
    }

    public ObjectReader getObjectReader(long hashCode) {
        int tclHash;
        ConcurrentHashMap tclHashCache;
        Long hashCodeObj = new Long(hashCode);
        ObjectReader objectReader = null;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != null && tcl != JSON.class.getClassLoader() && (tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash = System.identityHashCode(tcl))) != null) {
            objectReader = (ObjectReader)tclHashCache.get(hashCodeObj);
        }
        if (objectReader == null) {
            objectReader = (ObjectReader)this.hashCache.get(hashCodeObj);
        }
        return objectReader;
    }

    public ObjectReader getObjectReader(String typeName, Class<?> expectClass, long features) {
        Class autoTypeClass = this.checkAutoType(typeName, expectClass, features);
        if (autoTypeClass == null) {
            return null;
        }
        boolean fieldBased = (features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.getObjectReader(autoTypeClass, fieldBased);
        this.registerIfAbsent(Fnv.hashCode64(typeName), objectReader);
        return objectReader;
    }

    public Class checkAutoType(String typeName, Class<?> expectClass, long features) {
        int ch;
        int i;
        long hash;
        Class<?> resolvedClass;
        if (typeName == null) {
            return null;
        }
        if (this.autoTypeBeforeHandler != null && (resolvedClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
            return resolvedClass;
        }
        int typeNameLength = typeName.length();
        if (typeNameLength >= 192) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        if (expectClass != null && expectClass.getName().equals(typeName)) {
            if (this.autoTypeHandler != null) {
                this.autoTypeHandler.accept(expectClass);
            }
            return expectClass;
        }
        boolean autoTypeSupport = (features & JSONReader.Feature.SupportAutoType.mask) != 0L;
        Class clazz = null;
        long BASIC = -3750763034362895579L;
        long PRIME = 1099511628211L;
        if (autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.acceptHashCodes, hash *= 1099511628211L) >= 0 && (clazz = TypeUtils.loadClass(typeName)) != null) {
                    if (this.autoTypeHandler != null) {
                        this.autoTypeHandler.accept(expectClass);
                    }
                    return clazz;
                }
                if (Arrays.binarySearch(this.denyHashCodes, hash) < 0 || TypeUtils.getMapping(typeName) != null) continue;
                throw new JSONException("autoType is not support. " + typeName);
            }
        }
        if (clazz == null) {
            clazz = TypeUtils.getMapping(typeName);
        }
        if (clazz != null) {
            if (expectClass != null && expectClass != Object.class && clazz != HashMap.class && !expectClass.isAssignableFrom(clazz)) {
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
            if (this.autoTypeHandler != null) {
                this.autoTypeHandler.accept(expectClass);
            }
            return clazz;
        }
        if (!autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.denyHashCodes, hash *= 1099511628211L) >= 0) {
                    throw new JSONException("autoType is not support. " + typeName);
                }
                if (Arrays.binarySearch(this.acceptHashCodes, hash) < 0) continue;
                if (clazz == null) {
                    clazz = TypeUtils.loadClass(typeName);
                }
                if (expectClass != null && expectClass.isAssignableFrom(clazz)) {
                    throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                }
                return clazz;
            }
        }
        if (clazz == null && autoTypeSupport) {
            clazz = TypeUtils.loadClass(typeName);
        }
        if (clazz != null) {
            if (ClassLoader.class.isAssignableFrom(clazz) || JDKUtils.isSQLDataSourceOrRowSet(clazz)) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            if (expectClass != null) {
                if (expectClass.isAssignableFrom(clazz)) {
                    if (this.autoTypeHandler != null) {
                        this.autoTypeHandler.accept(expectClass);
                    }
                    return clazz;
                }
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
        }
        if (!autoTypeSupport) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        if (this.autoTypeHandler != null) {
            this.autoTypeHandler.accept(expectClass);
        }
        return clazz;
    }

    public List<ObjectReaderModule> getModules() {
        return this.modules;
    }

    public ObjectReader getObjectReader(Type objectType) {
        return this.getObjectReader(objectType, false);
    }

    public ObjectReader getObjectReader(Type objectType, boolean fieldBased) {
        ObjectReader previous;
        ObjectReader boundObjectReader;
        Type bound;
        Type[] bounds;
        ObjectReader objectReader;
        if (objectType == null) {
            objectType = Object.class;
        }
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectType) : (ObjectReader)this.cache.get(objectType);
        if (objectReader != null) {
            return objectReader;
        }
        for (ObjectReaderModule module : this.modules) {
            ObjectReader previous2;
            objectReader = module.getObjectReader(this, (Type)objectType);
            if (objectReader == null) continue;
            ObjectReader objectReader3 = previous2 = fieldBased ? this.cacheFieldBased.putIfAbsent((Type)objectType, objectReader) : this.cache.putIfAbsent((Type)objectType, objectReader);
            if (previous2 != null) {
                objectReader = previous2;
            }
            return objectReader;
        }
        if (objectType instanceof TypeVariable && (bounds = ((TypeVariable)objectType).getBounds()).length > 0 && (bound = bounds[0]) instanceof Class && (boundObjectReader = this.getObjectReader(bound, fieldBased)) != null) {
            ObjectReader previous3;
            ObjectReader objectReader4 = previous3 = fieldBased ? this.cacheFieldBased.putIfAbsent((Type)objectType, boundObjectReader) : this.cache.putIfAbsent((Type)objectType, boundObjectReader);
            if (previous3 != null) {
                boundObjectReader = previous3;
            }
            return boundObjectReader;
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)objectType;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (rawType instanceof Class) {
                ObjectReader rawClassReader;
                Class rawClass = (Class)rawType;
                boolean generic = false;
                for (Class clazz = rawClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    if (clazz.getTypeParameters().length <= 0) continue;
                    generic = true;
                    break;
                }
                if (!(typeArguments.length != 0 && generic || (rawClassReader = this.getObjectReader(rawClass, fieldBased)) == null)) {
                    ObjectReader previous4;
                    ObjectReader objectReader5 = previous4 = fieldBased ? this.cacheFieldBased.putIfAbsent((Type)objectType, rawClassReader) : this.cache.putIfAbsent((Type)objectType, rawClassReader);
                    if (previous4 != null) {
                        rawClassReader = previous4;
                    }
                    return rawClassReader;
                }
            }
        }
        Class<?> objectClass = TypeUtils.getMapping((Type)objectType);
        if (objectReader == null) {
            objectReader = this.getCreator().createObjectReader(objectClass, (Type)objectType, fieldBased, this.modules);
        }
        ObjectReader objectReader6 = previous = fieldBased ? this.cacheFieldBased.putIfAbsent((Type)objectType, objectReader) : this.cache.putIfAbsent((Type)objectType, objectReader);
        if (previous != null) {
            objectReader = previous;
        }
        return objectReader;
    }

    public AutoTypeBeforeHandler getAutoTypeBeforeHandler() {
        return this.autoTypeBeforeHandler;
    }

    public void setAutoTypeBeforeHandler(AutoTypeBeforeHandler autoTypeBeforeHandler) {
        this.autoTypeBeforeHandler = autoTypeBeforeHandler;
    }

    static {
        Class handlerClass;
        String property = System.getProperty("fastjson2.parser.deny");
        if (property == null) {
            property = JSONFactory.getProperty("fastjson2.parser.deny");
        }
        DENYS = property != null && property.length() > 0 ? property.split(",") : new String[0];
        property = System.getProperty("fastjson2.autoTypeAccept");
        if (property == null) {
            property = JSONFactory.getProperty("fastjson2.autoTypeAccept");
        }
        AUTO_TYPE_ACCEPT_LIST = property != null && property.length() > 0 ? property.split(",") : new String[0];
        property = System.getProperty("fastjson2.autoTypeBeforeHandler");
        if (property == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.autoTypeBeforeHandler");
        }
        if (property != null) {
            property = property.trim();
        }
        if (property != null && !property.isEmpty() && (handlerClass = TypeUtils.loadClass(property)) != null) {
            try {
                DEFAULT_AUTO_TYPE_BEFORE_HANDLER = (AutoTypeBeforeHandler)handlerClass.newInstance();
            }
            catch (Exception ignored) {
                DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR = true;
            }
        }
        if ((property = System.getProperty("fastjson2.autoTypeHandler")) == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.autoTypeHandler");
        }
        if (property != null) {
            property = property.trim();
        }
        if (property != null && !property.isEmpty() && (handlerClass = TypeUtils.loadClass(property)) != null) {
            try {
                DEFAULT_AUTO_TYPE_HANDLER = (Consumer)handlerClass.newInstance();
            }
            catch (Exception ignored) {
                DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR = true;
            }
        }
    }

    public static interface AutoTypeBeforeHandler {
        public Class<?> apply(String var1, Class<?> var2, long var3);
    }
}

