/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;

final class ObjectReaderImplObject
extends ObjectReaderBaseModule.PrimitiveImpl {
    static final ObjectReaderImplObject INSTANCE = new ObjectReaderImplObject();

    ObjectReaderImplObject() {
    }

    @Override
    public Object readObject(JSONReader jsonReader, long features) {
        Object value;
        if (jsonReader.isJSONB()) {
            return jsonReader.readAny();
        }
        JSONReader.Context context = jsonReader.getContext();
        if (jsonReader.isObject()) {
            boolean supportAutoType = context.isEnable(JSONReader.Feature.SupportAutoType);
            if (!supportAutoType) {
                return ObjectReaderImplMap.INSTANCE_OBJECT.readObject(jsonReader, features);
            }
            jsonReader.next();
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == HASH_TYPE && supportAutoType) {
                String typeName;
                long typeHash = jsonReader.readTypeHashCode();
                ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException("auotype not support : " + typeName);
                }
                jsonReader.setTypeRedirect(true);
                return autoTypeObjectReader.readObject(jsonReader, features);
            }
            return ObjectReaderImplMap.INSTANCE_OBJECT.readObject(jsonReader, features);
        }
        switch (jsonReader.current()) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                value = jsonReader.readNumber();
                break;
            }
            case '[': {
                value = jsonReader.readArray();
                break;
            }
            case '\"': 
            case '\'': {
                value = jsonReader.readString();
                break;
            }
            case 'f': 
            case 't': {
                value = jsonReader.readBoolValue();
                break;
            }
            case 'n': {
                jsonReader.readNull();
                value = null;
                break;
            }
            default: {
                throw new JSONException("TODO : " + jsonReader.current());
            }
        }
        return value;
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, long features) {
        byte type = jsonReader.getType();
        if (type >= 73 && type <= 125) {
            return jsonReader.readString();
        }
        if (type == -110) {
            ObjectReader autoTypeObjectReader = jsonReader.checkAutoType(Object.class, 0L, features);
            return autoTypeObjectReader.readJSONBObject(jsonReader, features);
        }
        if (type == -81) {
            jsonReader.next();
            return null;
        }
        return jsonReader.readAny();
    }
}

