/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.util.Arrays;

final class ObjectReaderImplEnum
implements ObjectReader {
    final Class enumClass;
    final long typeNameHash;
    protected final Enum[] enums;
    protected final Enum[] ordinalEnums;
    protected long[] enumNameHashCodes;
    static final long HASH_NAME = Fnv.hashCode64("name");
    static final long HASH_ORDINAL = Fnv.hashCode64("ordinal");

    public ObjectReaderImplEnum(Class enumClass, Enum[] enums, Enum[] ordinalEnums, long[] enumNameHashCodes) {
        this.enumClass = enumClass;
        this.typeNameHash = Fnv.hashCode64(TypeUtils.getTypeName(enumClass));
        this.enums = enums;
        this.ordinalEnums = ordinalEnums;
        this.enumNameHashCodes = enumNameHashCodes;
    }

    public Enum getEnumByHashCode(long hashCode) {
        if (this.enums == null) {
            return null;
        }
        int enumIndex = Arrays.binarySearch(this.enumNameHashCodes, hashCode);
        if (enumIndex < 0) {
            return null;
        }
        return this.enums[enumIndex];
    }

    public Enum<?> valueOf(int ordinal) {
        return this.ordinalEnums[ordinal];
    }

    public Enum getEnumByOrdinal(int ordinal) {
        return this.ordinalEnums[ordinal];
    }

    public Object readJSONBObject(JSONReader jsonReader, long features) {
        Enum fieldValue;
        boolean isInt;
        long typeNameHash;
        byte type = jsonReader.getType();
        if (jsonReader.nextIfMatch((byte)-110) && (typeNameHash = jsonReader.readTypeHashCode()) != this.typeNameHash) {
            throw new JSONException("not support enumType : " + jsonReader.getString());
        }
        boolean bl = isInt = type >= -16 && type <= 72;
        if (isInt) {
            int ordinal = jsonReader.readInt32Value();
            fieldValue = this.getEnumByOrdinal(ordinal);
        } else {
            fieldValue = this.getEnumByHashCode(jsonReader.readValueHashCode());
            if (fieldValue == null) {
                long nameHash = jsonReader.getNameHashCodeLCase();
                fieldValue = this.getEnumByHashCode(nameHash);
            }
        }
        return fieldValue;
    }

    public Object readObject(JSONReader jsonReader, long features) {
        Enum fieldValue;
        if (jsonReader.isInt()) {
            fieldValue = this.getEnumByOrdinal(jsonReader.readInt32Value());
        } else {
            fieldValue = this.getEnumByHashCode(jsonReader.readValueHashCode());
            if (fieldValue == null) {
                fieldValue = this.getEnumByHashCode(jsonReader.getNameHashCodeLCase());
            }
        }
        return fieldValue;
    }
}

