/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.codegen.ObjectReaderGen;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.util.DynamicClassLoader;
import com.alibaba.fastjson2.util.JDKUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class ObjectReaderCreatorDynamicCompile
extends ObjectReaderCreator {
    public static final ObjectReaderCreatorDynamicCompile INSTANCE = new ObjectReaderCreatorDynamicCompile();
    static DiagnosticCollector<JavaFileObject> DIAGNOSTIC_COLLECTOR = new DiagnosticCollector();

    @Override
    public <T> ObjectReader<T> createObjectReader(Class<T> objectType) {
        ObjectReader objectReader;
        if (JDKUtils.JVM_VERSION >= 17 && !JDKUtils.JAVAC_UNNAMED) {
            return super.createObjectReader(objectType);
        }
        FieldReader[] fieldReaderArray = this.createFieldReaders(objectType, objectType);
        StringBuilder out = new StringBuilder();
        ObjectReaderGen gen = new ObjectReaderGen(objectType, out);
        gen.gen();
        String sourceCode = out.toString();
        try {
            objectReader = (ObjectReader)ObjectReaderCreatorDynamicCompile.compile(gen.getPackageName(), gen.getClassName(), sourceCode, new Class[]{FieldReader[].class}, new Object[]{fieldReaderArray});
        }
        catch (Exception e) {
            throw new JSONException("compile error", e);
        }
        return objectReader;
    }

    public static <T> T compile(String packageName, String className, String sourceCode, Class<?>[] constructorParamTypes, Object[] constructorParams) throws Exception {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-source");
        options.add("1.8");
        options.add("-target");
        options.add("1.8");
        StandardJavaFileManager manager = compiler.getStandardFileManager(DIAGNOSTIC_COLLECTOR, null, null);
        JdkDynamicCompileClassLoader classLoader = new JdkDynamicCompileClassLoader();
        JdkDynamicCompileJavaFileManager fileManager = new JdkDynamicCompileJavaFileManager(manager, classLoader);
        String qualifiedName = packageName + "." + className;
        CharSequenceJavaFileObject javaFileObject = new CharSequenceJavaFileObject(className, sourceCode);
        fileManager.addJavaFileObject(StandardLocation.SOURCE_PATH, packageName, className + ".java", javaFileObject);
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, fileManager, DIAGNOSTIC_COLLECTOR, options, null, Collections.singleton(javaFileObject));
        Boolean result = compilationTask.call();
        if (!result.booleanValue()) {
            Diagnostic<JavaFileObject> diagnostic = DIAGNOSTIC_COLLECTOR.getDiagnostics().get(0);
            System.out.println(diagnostic);
            throw new JSONException("compile error. \n" + sourceCode);
        }
        Class<?> klass = classLoader.loadClass(qualifiedName);
        Constructor<?> constructor = klass.getDeclaredConstructor(constructorParamTypes);
        return (T)constructor.newInstance(constructorParams);
    }

    public static class JdkDynamicCompileJavaFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final JdkDynamicCompileClassLoader classLoader;
        private final Map<URI, JavaFileObject> javaFileObjectMap = new ConcurrentHashMap<URI, JavaFileObject>();

        public JdkDynamicCompileJavaFileManager(JavaFileManager fileManager, JdkDynamicCompileClassLoader classLoader) {
            super(fileManager);
            this.classLoader = classLoader;
        }

        private static URI fromLocation(JavaFileManager.Location location, String packageName, String relativeName) {
            try {
                return new URI(location.getName() + '/' + packageName + '/' + relativeName);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            JavaFileObject javaFileObject = this.javaFileObjectMap.get(JdkDynamicCompileJavaFileManager.fromLocation(location, packageName, relativeName));
            if (null != javaFileObject) {
                return javaFileObject;
            }
            return super.getFileForInput(location, packageName, relativeName);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            CharSequenceJavaFileObject javaFileObject = new CharSequenceJavaFileObject(className, kind);
            this.classLoader.addJavaFileObject(className, javaFileObject);
            return javaFileObject;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.classLoader;
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            if (file instanceof CharSequenceJavaFileObject) {
                return file.getName();
            }
            return super.inferBinaryName(location, file);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            Iterable<JavaFileObject> superResult = super.list(location, packageName, kinds, recurse);
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
                for (JavaFileObject file : this.javaFileObjectMap.values()) {
                    if (file.getKind() != JavaFileObject.Kind.CLASS || !file.getName().startsWith(packageName)) continue;
                    result.add(file);
                }
                result.addAll(this.classLoader.listJavaFileObject());
            } else if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
                for (JavaFileObject file : this.javaFileObjectMap.values()) {
                    if (file.getKind() != JavaFileObject.Kind.SOURCE || !file.getName().startsWith(packageName)) continue;
                    result.add(file);
                }
            }
            for (JavaFileObject javaFileObject : superResult) {
                result.add(javaFileObject);
            }
            return result;
        }

        public void addJavaFileObject(JavaFileManager.Location location, String packageName, String relativeName, JavaFileObject javaFileObject) {
            this.javaFileObjectMap.put(JdkDynamicCompileJavaFileManager.fromLocation(location, packageName, relativeName), javaFileObject);
        }
    }

    public static class JdkDynamicCompileClassLoader
    extends DynamicClassLoader {
        public static final String CLASS_EXTENSION = ".class";
        private final Map<String, JavaFileObject> javaFileObjectMap = new ConcurrentHashMap<String, JavaFileObject>();

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            JavaFileObject javaFileObject = this.javaFileObjectMap.get(name);
            if (null != javaFileObject) {
                CharSequenceJavaFileObject charSequenceJavaFileObject = (CharSequenceJavaFileObject)javaFileObject;
                byte[] byteCode = charSequenceJavaFileObject.getByteCode();
                return this.defineClass(name, byteCode, 0, byteCode.length);
            }
            return super.findClass(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            String qualifiedClassName;
            CharSequenceJavaFileObject javaFileObject;
            if (name.endsWith(CLASS_EXTENSION) && null != (javaFileObject = (CharSequenceJavaFileObject)this.javaFileObjectMap.get(qualifiedClassName = name.substring(0, name.length() - CLASS_EXTENSION.length()).replace('/', '.'))) && null != javaFileObject.getByteCode()) {
                return new ByteArrayInputStream(javaFileObject.getByteCode());
            }
            return super.getResourceAsStream(name);
        }

        void addJavaFileObject(String qualifiedClassName, JavaFileObject javaFileObject) {
            this.javaFileObjectMap.put(qualifiedClassName, javaFileObject);
        }

        Collection<JavaFileObject> listJavaFileObject() {
            return Collections.unmodifiableCollection(this.javaFileObjectMap.values());
        }
    }

    public static class CharSequenceJavaFileObject
    extends SimpleJavaFileObject {
        public static final String CLASS_EXTENSION = ".class";
        public static final String JAVA_EXTENSION = ".java";
        private ByteArrayOutputStream byteCode;
        private final CharSequence sourceCode;

        private static URI fromClassName(String className) {
            try {
                return new URI(className);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(className, e);
            }
        }

        public CharSequenceJavaFileObject(String className, CharSequence sourceCode) {
            super(CharSequenceJavaFileObject.fromClassName(className + JAVA_EXTENSION), JavaFileObject.Kind.SOURCE);
            this.sourceCode = sourceCode;
        }

        public CharSequenceJavaFileObject(String fullClassName, JavaFileObject.Kind kind) {
            super(CharSequenceJavaFileObject.fromClassName(fullClassName), kind);
            this.sourceCode = null;
        }

        public CharSequenceJavaFileObject(URI uri, JavaFileObject.Kind kind) {
            super(uri, kind);
            this.sourceCode = null;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.sourceCode;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.getByteCode());
        }

        @Override
        public OutputStream openOutputStream() {
            this.byteCode = new ByteArrayOutputStream();
            return this.byteCode;
        }

        public byte[] getByteCode() {
            return this.byteCode.toByteArray();
        }
    }
}

