/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;

public abstract class ObjectReaderBean<T>
implements ObjectReader<T> {
    protected final Class objectClass;
    protected final String typeName;
    protected final long typeNameHash;
    byte[] jsonbClassInfo;
    long[] jsonbClassInfoFieldNameHashCodes;

    protected ObjectReaderBean(Class objectClass, String typeName) {
        if (typeName == null && objectClass != null) {
            typeName = TypeUtils.getTypeName(objectClass);
        }
        this.objectClass = objectClass;
        this.typeName = typeName;
        this.typeNameHash = typeName != null ? Fnv.hashCode64(typeName) : 0L;
    }

    public ObjectReader checkAutoType(JSONReader jsonReader, Class listClass, long features) {
        ObjectReader autoTypeObjectReader = null;
        if (jsonReader.nextIfMatch((byte)-110)) {
            boolean isSupportAutoType;
            long typeHash = jsonReader.readTypeHashCode();
            JSONReader.Context context = jsonReader.getContext();
            autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
            if (autoTypeObjectReader == null) {
                String typeName = jsonReader.getString();
                autoTypeObjectReader = context.getObjectReaderAutoType(typeName, listClass, features);
            }
            if (autoTypeObjectReader == null) {
                throw new JSONException("auotype not support : " + jsonReader.getString());
            }
            if (typeHash == this.typeNameHash) {
                return this;
            }
            boolean bl = isSupportAutoType = ((context.getFeatures() | features) & JSONReader.Feature.SupportAutoType.mask) != 0L;
            if (!isSupportAutoType) {
                return null;
            }
        }
        return autoTypeObjectReader;
    }
}

