/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.util.JdbcSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

class FieldReaderObjectField<T>
extends FieldReaderImpl<T> {
    protected final Field field;
    protected ObjectReader fieldObjectReader;

    FieldReaderObjectField(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Field field) {
        super(fieldName, fieldType == null ? field.getType() : fieldType, fieldClass, ordinal, features, format);
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.reader != null) {
            return this.reader;
        }
        if (this.format != null && !this.format.isEmpty()) {
            String typeName;
            switch (typeName = this.fieldType.getTypeName()) {
                case "java.sql.Time": {
                    this.reader = JdbcSupport.createTimeReader(this.format);
                    return this.reader;
                }
                case "java.sql.Timestamp": {
                    this.reader = JdbcSupport.createTimestampReader(this.format);
                    return this.reader;
                }
                case "java.sql.Date": {
                    return JdbcSupport.createDateReader(this.format);
                }
            }
        }
        if (Map.class.isAssignableFrom(this.fieldClass)) {
            this.reader = ObjectReaderImplMap.of(this.fieldType, this.fieldClass, this.features);
            return this.reader;
        }
        if (Collection.class.isAssignableFrom(this.fieldClass)) {
            this.reader = ObjectReaderImplList.of(this.fieldType, this.fieldClass, this.features);
            return this.reader;
        }
        this.reader = jsonReader.getObjectReader(this.fieldType);
        return this.reader;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        if (jsonReader.isReference()) {
            String reference = jsonReader.readReference();
            if (reference.equals("..")) {
                this.accept(object, object);
            } else {
                this.addResolveTask(jsonReader, object, reference);
            }
            return;
        }
        int offset = jsonReader.getOffset();
        try {
            ObjectReader autoTypeObjectReader;
            Object value = jsonReader.nextIfNull() ? (this.fieldClass == OptionalInt.class ? OptionalInt.empty() : (this.fieldClass == OptionalLong.class ? OptionalLong.empty() : (this.fieldClass == OptionalDouble.class ? OptionalDouble.empty() : (this.fieldClass == Optional.class ? Optional.empty() : null)))) : (jsonReader.isJSONB() ? (this.fieldClass == Object.class ? ((autoTypeObjectReader = jsonReader.checkAutoType(Object.class, 0L, this.features)) != null ? autoTypeObjectReader.readJSONBObject(jsonReader, this.features) : jsonReader.readAny()) : this.fieldObjectReader.readJSONBObject(jsonReader, this.features)) : this.fieldObjectReader.readObject(jsonReader, this.features));
            this.accept(object, value);
        }
        catch (Exception | IllegalAccessError ex) {
            throw new JSONException("read field '" + this.field.getDeclaringClass().getName() + "." + this.field.getName() + "' error, offset " + offset, ex);
        }
    }

    @Override
    public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        if (jsonReader.isReference()) {
            String reference = jsonReader.readReference();
            if (reference.equals("..")) {
                this.accept(object, object);
            } else {
                this.addResolveTask(jsonReader, object, reference);
            }
            return;
        }
        Object value = this.fieldObjectReader.readJSONBObject(jsonReader, this.features);
        this.accept(object, value);
    }

    @Override
    public void accept(T object, boolean value) {
        try {
            this.field.setBoolean(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, byte value) {
        try {
            this.field.setByte(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, short value) {
        try {
            this.field.setShort(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, int value) {
        try {
            this.field.setInt(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, long value) {
        try {
            this.field.setLong(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, float value) {
        try {
            this.field.setFloat(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, double value) {
        try {
            this.field.setDouble(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, char value) {
        try {
            this.field.setChar(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, Object value) {
        try {
            this.field.set(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        return jsonReader.isJSONB() ? this.fieldObjectReader.readJSONBObject(jsonReader, this.features) : this.fieldObjectReader.readObject(jsonReader, this.features);
    }

    public Object readFieldValueJSONB(JSONReader jsonReader) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        return this.fieldObjectReader.readJSONBObject(jsonReader, this.features);
    }
}

