/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderList;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;

class FieldReaderListField<T>
extends FieldReaderObjectField<T>
implements FieldReaderList<T, Object> {
    private Type itemType;
    final long fieldClassHash;
    ObjectReader itemReader;

    FieldReaderListField(String fieldName, Type fieldType, Class fieldClass, Type itemType, int ordinal, long features, String format, Field field) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, field);
        this.itemType = itemType;
        this.fieldClassHash = fieldClass == null ? 0L : Fnv.hashCode64(TypeUtils.getTypeName(fieldClass));
        this.fieldObjectReader = ObjectReaderImplList.of(fieldType, fieldClass, features);
        if (format != null && itemType == Date.class) {
            this.itemReader = new ObjectReaderBaseModule.UtilDateImpl(format);
        }
    }

    @Override
    public Type getItemType() {
        return this.itemType;
    }

    @Override
    public ObjectReader checkObjectAutoType(JSONReader jsonReader) {
        if (jsonReader.nextIfMatch((byte)-110)) {
            long typeHash = jsonReader.readTypeHashCode();
            boolean isSupportAutoType = jsonReader.isSupportAutoType(this.features);
            if (!isSupportAutoType) {
                throw new JSONException("autoType not support input " + jsonReader.getString());
            }
            ObjectReader autoTypeObjectReader = jsonReader.getContext().getObjectReaderAutoType(typeHash);
            if (autoTypeObjectReader == null) {
                String typeName = jsonReader.getString();
                autoTypeObjectReader = jsonReader.getContext().getObjectReaderAutoType(typeName, this.getFieldClass(), this.features);
            }
            if (autoTypeObjectReader instanceof ObjectReaderImplList) {
                ObjectReaderImplList listReader = (ObjectReaderImplList)autoTypeObjectReader;
                autoTypeObjectReader = new ObjectReaderImplList(this.fieldType, this.fieldClass, listReader.instanceType, this.itemType, listReader.builder);
            }
            if (autoTypeObjectReader == null) {
                throw new JSONException("auotype not support : " + jsonReader.getString());
            }
            return autoTypeObjectReader;
        }
        return null;
    }

    @Override
    public ObjectReader getItemObjectReader(JSONReader.Context ctx) {
        if (this.itemReader != null) {
            return this.itemReader;
        }
        this.itemReader = ctx.getObjectReader(this.itemType);
        return this.itemReader;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (jsonReader.nextIfNull()) {
            return;
        }
        if (jsonReader.isReference()) {
            String reference = jsonReader.readReference();
            if (reference.equals("..")) {
                this.accept(object, object);
            } else {
                this.addResolveTask(jsonReader, object, reference);
            }
            return;
        }
        JSONReader.Context context = jsonReader.getContext();
        if (jsonReader.isJSONB()) {
            long typeHash;
            Class fieldClass = this.fieldClass;
            ObjectReader autoTypeReader = null;
            Function builder = this.fieldObjectReader.getBuildFunction();
            if (jsonReader.nextIfMatch((byte)-110) && (typeHash = jsonReader.readTypeHashCode()) != this.fieldClassHash && jsonReader.isSupportAutoType(this.features)) {
                autoTypeReader = context.getObjectReaderAutoType(typeHash);
                if (autoTypeReader == null) {
                    String typeName = jsonReader.getString();
                    autoTypeReader = context.getObjectReaderAutoType(typeName, fieldClass, this.fieldClassHash);
                }
                builder = autoTypeReader.getBuildFunction();
            }
            Collection list = autoTypeReader != null ? (Collection)autoTypeReader.createInstance() : (Collection)this.fieldObjectReader.createInstance();
            int entryCnt = jsonReader.startArray();
            ObjectReader itemObjectReader = this.getItemObjectReader(context);
            for (int i = 0; i < entryCnt; ++i) {
                Object value;
                if (jsonReader.isReference()) {
                    String reference = jsonReader.readReference();
                    if (reference.equals("..")) {
                        value = list;
                    } else {
                        this.addResolveTask(jsonReader, list, i, reference);
                        if (list instanceof TreeSet) continue;
                        value = null;
                    }
                } else {
                    value = itemObjectReader.readJSONBObject(jsonReader, this.features);
                }
                list.add(value);
            }
            if (builder != null) {
                list = (Collection)builder.apply(list);
            }
            this.accept(object, list);
            return;
        }
        if (jsonReader.current() == '[') {
            JSONReader.Context ctx = context;
            ObjectReader itemObjectReader = this.getItemObjectReader(ctx);
            List list = this.createList();
            jsonReader.next();
            while (!jsonReader.nextIfMatch(']')) {
                list.add(itemObjectReader.readObject(jsonReader, 0L));
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            this.accept(object, list);
            jsonReader.nextIfMatch(',');
            return;
        }
        if (jsonReader.isString()) {
            String str = jsonReader.readString();
            if (str.isEmpty()) {
                this.accept(object, null);
                return;
            }
            throw new JSONException("listField not support input : " + str);
        }
        throw new JSONException("listField not support input : " + jsonReader.current());
    }
}

