/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class FieldReaderDateField<T>
extends FieldReaderObjectField<T> {
    private ObjectReader dateReader;
    volatile SimpleDateFormat formatter;
    static final AtomicReferenceFieldUpdater<FieldReaderDateField, SimpleDateFormat> FORMATTER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FieldReaderDateField.class, SimpleDateFormat.class, "formatter");

    FieldReaderDateField(String fieldName, Class fieldType, int ordinal, long features, String format, Field field) {
        super(fieldName, fieldType, fieldType, ordinal, features, format, field);
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderBaseModule.UtilDateImpl.INSTANCE : new ObjectReaderBaseModule.UtilDateImpl(this.format);
        }
        return this.dateReader;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Date fieldValue;
        if (jsonReader.isInt()) {
            long millis = jsonReader.readInt64Value();
            fieldValue = new Date(millis);
        } else if (jsonReader.isNull()) {
            jsonReader.readNull();
            fieldValue = null;
        } else if (this.format != null) {
            SimpleDateFormat formatter = FORMATTER_UPDATER.getAndSet(this, null);
            if (formatter == null) {
                formatter = new SimpleDateFormat(this.format);
            }
            String str = null;
            try {
                str = jsonReader.readString();
                fieldValue = formatter.parse(str);
            }
            catch (ParseException e) {
                throw new JSONException("parse date error, fieldName : " + this.fieldName, e);
            }
            finally {
                FORMATTER_UPDATER.set(this, formatter);
            }
        } else {
            long millis = jsonReader.readMillisFromString();
            fieldValue = new Date(millis);
        }
        try {
            this.field.set(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, Object value) {
        if (value instanceof String) {
            JSONReader jsonReader = JSONReader.of(JSON.toJSONString(value));
            value = this.getObjectReader(jsonReader).readObject(jsonReader);
        }
        try {
            this.field.set(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }
}

