/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.reader.FieldReaderReadOnly;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;

class FieldReaderAtomicIntegerMethodReadOnly<T>
extends FieldReaderImpl<T>
implements FieldReaderReadOnly<T> {
    final Method setter;

    FieldReaderAtomicIntegerMethodReadOnly(String fieldName, Class fieldType, int ordinal, Method setter) {
        super(fieldName, fieldType, fieldType, ordinal, 0L, null);
        this.setter = setter;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void accept(T object, Object value) {
        if (value == null) {
            return;
        }
        try {
            AtomicInteger atomic = (AtomicInteger)this.setter.invoke(object, new Object[0]);
            atomic.set((Integer)value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Integer value = jsonReader.readInt32();
        this.accept(object, value);
    }

    @Override
    public String toString() {
        return this.setter.getName();
    }
}

