/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.asm;

import com.alibaba.fastjson2.asm.ByteVector;
import com.alibaba.fastjson2.asm.Edge;
import com.alibaba.fastjson2.asm.Frame;

public class Label {
    static final int FLAG_DEBUG_ONLY = 1;
    static final int FLAG_JUMP_TARGET = 2;
    static final int FLAG_RESOLVED = 4;
    static final int FLAG_REACHABLE = 8;
    static final int FORWARD_REFERENCES_CAPACITY_INCREMENT = 6;
    static final int FORWARD_REFERENCE_TYPE_MASK = -268435456;
    static final int FORWARD_REFERENCE_TYPE_SHORT = 0x10000000;
    static final int FORWARD_REFERENCE_TYPE_WIDE = 0x20000000;
    static final int FORWARD_REFERENCE_HANDLE_MASK = 0xFFFFFFF;
    static final Label EMPTY_LIST = new Label();
    public Object info;
    short flags;
    int bytecodeOffset;
    private int[] forwardReferences;
    short outputStackMax;
    Frame frame;
    Label nextBasicBlock;
    Edge outgoingEdges;
    Label nextListElement;

    final Label getCanonicalInstance() {
        return this.frame == null ? this : this.frame.owner;
    }

    final void put(ByteVector code, int sourceInsnBytecodeOffset, boolean wideReference) {
        if ((this.flags & 4) == 0) {
            if (wideReference) {
                this.addForwardReference(sourceInsnBytecodeOffset, 0x20000000, code.length);
                code.putInt(-1);
            } else {
                this.addForwardReference(sourceInsnBytecodeOffset, 0x10000000, code.length);
                code.putShort(-1);
            }
        } else if (wideReference) {
            code.putInt(this.bytecodeOffset - sourceInsnBytecodeOffset);
        } else {
            code.putShort(this.bytecodeOffset - sourceInsnBytecodeOffset);
        }
    }

    private void addForwardReference(int sourceInsnBytecodeOffset, int referenceType, int referenceHandle) {
        int lastElementIndex;
        if (this.forwardReferences == null) {
            this.forwardReferences = new int[6];
        }
        if ((lastElementIndex = this.forwardReferences[0]) + 2 >= this.forwardReferences.length) {
            int[] newValues = new int[this.forwardReferences.length + 6];
            System.arraycopy(this.forwardReferences, 0, newValues, 0, this.forwardReferences.length);
            this.forwardReferences = newValues;
        }
        this.forwardReferences[++lastElementIndex] = sourceInsnBytecodeOffset;
        this.forwardReferences[++lastElementIndex] = referenceType | referenceHandle;
        this.forwardReferences[0] = lastElementIndex;
    }

    final boolean resolve(byte[] code, int bytecodeOffset) {
        this.flags = (short)(this.flags | 4);
        this.bytecodeOffset = bytecodeOffset;
        if (this.forwardReferences == null) {
            return false;
        }
        boolean hasAsmInstructions = false;
        for (int i = this.forwardReferences[0]; i > 0; i -= 2) {
            int sourceInsnBytecodeOffset = this.forwardReferences[i - 1];
            int reference = this.forwardReferences[i];
            int relativeOffset = bytecodeOffset - sourceInsnBytecodeOffset;
            int handle = reference & 0xFFFFFFF;
            if ((reference & 0xF0000000) == 0x10000000) {
                if (relativeOffset < Short.MIN_VALUE || relativeOffset > Short.MAX_VALUE) {
                    int opcode = code[sourceInsnBytecodeOffset] & 0xFF;
                    code[sourceInsnBytecodeOffset] = opcode < 198 ? (byte)(opcode + 49) : (byte)(opcode + 20);
                    hasAsmInstructions = true;
                }
                code[handle++] = (byte)(relativeOffset >>> 8);
                code[handle] = (byte)relativeOffset;
                continue;
            }
            code[handle++] = (byte)(relativeOffset >>> 24);
            code[handle++] = (byte)(relativeOffset >>> 16);
            code[handle++] = (byte)(relativeOffset >>> 8);
            code[handle] = (byte)relativeOffset;
        }
        return hasAsmInstructions;
    }
}

