/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.asm;

import com.alibaba.fastjson2.asm.ClassReader;
import com.alibaba.fastjson2.asm.TypeCollector;
import com.alibaba.fastjson2.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class ASMUtils {
    static Map<Class, String> descMapping = new HashMap<Class, String>();
    static Map<Class, String> typeMapping = new HashMap<Class, String>();
    static final AtomicReference<char[]> descCacheRef;

    public static String type(Class<?> clazz) {
        String type = typeMapping.get(clazz);
        if (type != null) {
            return type;
        }
        if (clazz.isArray()) {
            return "[" + ASMUtils.desc(clazz.getComponentType());
        }
        if (clazz.isPrimitive()) {
            return typeMapping.get(clazz);
        }
        String clsName = clazz.getName();
        return clsName.replace('.', '/');
    }

    public static String desc(Class<?> clazz) {
        String desc = descMapping.get(clazz);
        if (desc != null) {
            return desc;
        }
        if (clazz.isPrimitive()) {
            return typeMapping.get(clazz);
        }
        if (clazz.isArray()) {
            return "[" + ASMUtils.desc(clazz.getComponentType());
        }
        String className = clazz.getName();
        char[] chars = descCacheRef.getAndSet(null);
        if (chars == null) {
            chars = new char[512];
        }
        chars[0] = 76;
        className.getChars(0, className.length(), chars, 1);
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] != '.') continue;
            chars[i] = 47;
        }
        chars[className.length() + 1] = 59;
        String str = new String(chars, 0, className.length() + 2);
        descCacheRef.compareAndSet(null, chars);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] lookupParameterNames(AccessibleObject methodOrCtor) {
        String className;
        String resourceName;
        InputStream is;
        Class<Object> declaringClass;
        String name;
        Class<?>[] types;
        if (methodOrCtor instanceof Method) {
            Method method = (Method)methodOrCtor;
            types = method.getParameterTypes();
            name = method.getName();
            declaringClass = method.getDeclaringClass();
        } else {
            Constructor constructor = (Constructor)methodOrCtor;
            types = constructor.getParameterTypes();
            declaringClass = constructor.getDeclaringClass();
            name = "<init>";
        }
        if (types.length == 0) {
            return new String[0];
        }
        ClassLoader classLoader = declaringClass.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((is = classLoader.getResourceAsStream(resourceName = (className = declaringClass.getName()).replace('.', '/') + ".class")) == null) {
            return new String[0];
        }
        try {
            String[] parameterNames;
            ClassReader reader = new ClassReader(is, false);
            TypeCollector visitor = new TypeCollector(name, types);
            reader.accept(visitor);
            String[] stringArray = parameterNames = visitor.getParameterNamesForMethod();
            return stringArray;
        }
        catch (IOException e) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            IOUtils.close(is);
        }
    }

    static {
        descMapping.put(Integer.TYPE, "I");
        descMapping.put(Void.TYPE, "V");
        descMapping.put(Boolean.TYPE, "Z");
        descMapping.put(Character.TYPE, "C");
        descMapping.put(Byte.TYPE, "B");
        descMapping.put(Short.TYPE, "S");
        descMapping.put(Float.TYPE, "F");
        descMapping.put(Long.TYPE, "J");
        descMapping.put(Double.TYPE, "D");
        descMapping.put(List.class, "Ljava/util/List;");
        typeMapping.put(Integer.TYPE, "I");
        typeMapping.put(Void.TYPE, "V");
        typeMapping.put(Boolean.TYPE, "Z");
        typeMapping.put(Character.TYPE, "C");
        typeMapping.put(Byte.TYPE, "B");
        typeMapping.put(Short.TYPE, "S");
        typeMapping.put(Float.TYPE, "F");
        typeMapping.put(Long.TYPE, "J");
        typeMapping.put(Double.TYPE, "D");
        typeMapping.put(List.class, "java/util/List");
        descCacheRef = new AtomicReference();
    }
}

