/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public final class JSONFactory {
    public static final String PROPERTY_DENY_PROPERTY = "fastjson2.parser.deny";
    public static final String PROPERTY_AUTO_TYPE_ACCEPT = "fastjson2.autoTypeAccept";
    public static final String PROPERTY_AUTO_TYPE_SUPPORT = "fastjson2.autoTypeSupport";
    public static final String PROPERTY_AUTO_TYPE_HANDLER = "fastjson2.autoTypeHandler";
    public static final String PROPERTY_AUTO_TYPE_BEFORE_HANDLER = "fastjson2.autoTypeBeforeHandler";
    static final BigDecimal LOW;
    static final BigDecimal HIGH;
    static final BigInteger LOW_BIGINT;
    static final BigInteger HIGH_BIGINT;
    static final char[] CA;
    static final char[] DIGITS;
    static final int[] DIGITS2;
    static final Cache CACHE;
    static final int CACHE_THREAD = 0x100000;
    static final AtomicReferenceFieldUpdater<Cache, char[]> CHARS_UPDATER;
    static final AtomicReferenceFieldUpdater<Cache, byte[]> BYTES0_UPDATER;
    static final AtomicReferenceFieldUpdater<Cache, byte[]> BYTES1_UPDATER;
    static final AtomicReferenceFieldUpdater<Cache, byte[]> BYTES2_UPDATER;
    static final AtomicReferenceFieldUpdater<Cache, byte[]> BYTES3_UPDATER;
    static final AtomicReferenceFieldUpdater<Cache, byte[]> VALUE_BYTES_UPDATER;
    static final Properties DEFAULT_PROPERTIES;
    static ObjectWriterProvider defaultObjectWriterProvider;
    static ObjectReaderProvider defaultObjectReaderProvider;
    static final ThreadLocal<ObjectReaderCreator> readerCreatorLocal;
    static final ThreadLocal<ObjectReaderProvider> readerProviderLocal;
    static final ThreadLocal<ObjectWriterCreator> writerCreatorLocal;

    public static String getProperty(String key) {
        return DEFAULT_PROPERTIES.getProperty(key);
    }

    public static JSONWriter.Context createWriteContext() {
        return new JSONWriter.Context(defaultObjectWriterProvider);
    }

    public static JSONWriter.Context createWriteContext(JSONWriter.Feature ... features) {
        return new JSONWriter.Context(defaultObjectWriterProvider, features);
    }

    public static JSONReader.Context createReadContext() {
        return new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider());
    }

    public static ObjectWriterProvider getDefaultObjectWriterProvider() {
        return defaultObjectWriterProvider;
    }

    public static ObjectReaderProvider getDefaultObjectReaderProvider() {
        ObjectReaderProvider providerLocal = readerProviderLocal.get();
        if (providerLocal != null) {
            return providerLocal;
        }
        return defaultObjectReaderProvider;
    }

    public static void mixIn(Class target, Class mixinSource) {
        defaultObjectWriterProvider.mixIn(target, mixinSource);
        JSONFactory.getDefaultObjectReaderProvider().mixIn(target, mixinSource);
    }

    public static void setContextReaderCreator(ObjectReaderCreator creator) {
        readerCreatorLocal.set(creator);
    }

    public static void setContextObjectReaderProvider(ObjectReaderProvider creator) {
        readerProviderLocal.set(creator);
    }

    public static ObjectReaderCreator getContextReaderCreator() {
        return readerCreatorLocal.get();
    }

    public static void setContextWriterCreator(ObjectWriterCreator creator) {
        writerCreatorLocal.set(creator);
    }

    public static ObjectWriterCreator getContextWriterCreator() {
        return writerCreatorLocal.get();
    }

    static {
        int i;
        LOW = BigDecimal.valueOf(-9007199254740991L);
        HIGH = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
        LOW_BIGINT = BigInteger.valueOf(-9007199254740991L);
        HIGH_BIGINT = BigInteger.valueOf(0x1FFFFFFFFFFFFFL);
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        DIGITS2 = new int[103];
        for (i = 48; i <= 57; ++i) {
            JSONFactory.DIGITS2[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JSONFactory.DIGITS2[i] = i - 97 + 10;
        }
        for (i = 65; i <= 70; ++i) {
            JSONFactory.DIGITS2[i] = i - 65 + 10;
        }
        CACHE = new Cache();
        CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, char[].class, "chars");
        BYTES0_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, byte[].class, "bytes0");
        BYTES1_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, byte[].class, "bytes1");
        BYTES2_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, byte[].class, "bytes2");
        BYTES3_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, byte[].class, "bytes3");
        VALUE_BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, byte[].class, "valueBytes");
        DEFAULT_PROPERTIES = new Properties();
        defaultObjectWriterProvider = new ObjectWriterProvider();
        defaultObjectReaderProvider = new ObjectReaderProvider();
        readerCreatorLocal = new ThreadLocal();
        readerProviderLocal = new ThreadLocal();
        writerCreatorLocal = new ThreadLocal();
    }

    static final class SymbolTableImpl
    implements JSONB.SymbolTable {
        private final String[] names;
        private final long[] hashCodesOrigin;
        private final long[] hashCodes;
        private final short[] mapping;
        private final long hashCode64;

        SymbolTableImpl(String ... input) {
            TreeSet<String> nameSet = new TreeSet<String>();
            for (String name : input) {
                nameSet.add(name);
            }
            this.names = new String[nameSet.size()];
            int i = 0;
            for (String name : nameSet) {
                this.names[i++] = name;
            }
            long[] hashCodes = new long[this.names.length];
            for (i = 0; i < this.names.length; ++i) {
                long hashCode;
                hashCodes[i] = hashCode = Fnv.hashCode64(this.names[i]);
            }
            this.hashCodesOrigin = hashCodes;
            this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
            Arrays.sort(this.hashCodes);
            this.mapping = new short[this.hashCodes.length];
            for (i = 0; i < hashCodes.length; ++i) {
                long hashCode = hashCodes[i];
                int index = Arrays.binarySearch(this.hashCodes, hashCode);
                this.mapping[index] = (short)i;
            }
            long hashCode64 = -3750763034362895579L;
            for (int i2 = 0; i2 < hashCodes.length; ++i2) {
                hashCode64 ^= hashCodes[i2];
                hashCode64 *= 1099511628211L;
            }
            this.hashCode64 = hashCode64;
        }

        @Override
        public int size() {
            return this.names.length;
        }

        @Override
        public long hashCode64() {
            return this.hashCode64;
        }

        @Override
        public String getNameByHashCode(long hashCode) {
            int m = Arrays.binarySearch(this.hashCodes, hashCode);
            if (m < 0) {
                return null;
            }
            short index = this.mapping[m];
            return this.names[index];
        }

        @Override
        public int getOrdinalByHashCode(long hashCode) {
            int m = Arrays.binarySearch(this.hashCodes, hashCode);
            if (m < 0) {
                return -1;
            }
            return this.mapping[m] + 1;
        }

        @Override
        public int getOrdinal(String name) {
            long hashCode = Fnv.hashCode64(name);
            int m = Arrays.binarySearch(this.hashCodes, hashCode);
            if (m < 0) {
                return -1;
            }
            return this.mapping[m] + 1;
        }

        @Override
        public String getName(int ordinal) {
            return this.names[ordinal - 1];
        }

        @Override
        public long getHashCode(int ordinal) {
            return this.hashCodesOrigin[ordinal - 1];
        }
    }

    static final class Cache {
        volatile char[] chars;
        volatile byte[] bytes0;
        volatile byte[] bytes1;
        volatile byte[] bytes2;
        volatile byte[] bytes3;
        volatile byte[] valueBytes;

        Cache() {
        }
    }

    static final class UUIDUtils {
        private static final byte[] NIBBLES;

        UUIDUtils() {
        }

        protected static long parse4Nibbles(byte[] name, int pos) {
            byte[] ns = NIBBLES;
            byte ch1 = name[pos];
            byte ch2 = name[pos + 1];
            byte ch3 = name[pos + 2];
            byte ch4 = name[pos + 3];
            return (ch1 | ch2 | ch3 | ch4) > 255 ? -1L : (long)(ns[ch1] << 12 | ns[ch2] << 8 | ns[ch3] << 4 | ns[ch4]);
        }

        protected static long parse4Nibbles(char[] name, int pos) {
            byte[] ns = NIBBLES;
            char ch1 = name[pos];
            char ch2 = name[pos + 1];
            char ch3 = name[pos + 2];
            char ch4 = name[pos + 3];
            return (ch1 | ch2 | ch3 | ch4) > 255 ? -1L : (long)(ns[ch1] << 12 | ns[ch2] << 8 | ns[ch3] << 4 | ns[ch4]);
        }

        protected static long parse4Nibbles(String name, int pos) {
            char ch4;
            char ch3;
            char ch2;
            byte[] ns = NIBBLES;
            char ch1 = name.charAt(pos);
            return (ch1 | (ch2 = name.charAt(pos + 1)) | (ch3 = name.charAt(pos + 2)) | (ch4 = name.charAt(pos + 3))) > 255 ? -1L : (long)(ns[ch1] << 12 | ns[ch2] << 8 | ns[ch3] << 4 | ns[ch4]);
        }

        static {
            byte[] ns = new byte[256];
            Arrays.fill(ns, (byte)-1);
            ns[48] = 0;
            ns[49] = 1;
            ns[50] = 2;
            ns[51] = 3;
            ns[52] = 4;
            ns[53] = 5;
            ns[54] = 6;
            ns[55] = 7;
            ns[56] = 8;
            ns[57] = 9;
            ns[65] = 10;
            ns[66] = 11;
            ns[67] = 12;
            ns[68] = 13;
            ns[69] = 14;
            ns[70] = 15;
            ns[97] = 10;
            ns[98] = 11;
            ns[99] = 12;
            ns[100] = 13;
            ns[101] = 14;
            ns[102] = 15;
            NIBBLES = ns;
        }
    }

    static final class Utils {
        static volatile ToIntFunction<String> CODER_FUNCTION;
        static volatile Function<String, byte[]> VALUE_FUNCTION;
        static volatile boolean CODER_FUNCTION_ERROR;
        static BiFunction<char[], Boolean, String> STRING_CREATOR_JDK8;
        static Function<byte[], String> STRING_CREATOR_JDK11;
        static BiFunction<byte[], Charset, String> STRING_CREATOR_JDK17;
        static volatile boolean STRING_CREATOR_ERROR;

        Utils() {
        }

        static {
            STRING_CREATOR_ERROR = false;
        }
    }
}

