/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterPretty;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.JSONWriterUTF16JDK8;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;

public interface JSON {
    public static final String VERSION = "2.0.0";

    public static Object parse(String str) {
        JSONReader reader = JSONReader.of(str);
        ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
        return objectReader.readObject(reader, 0L);
    }

    public static Object parse(String str, JSONReader.Feature ... features) {
        JSONReader reader = JSONReader.of(str);
        reader.getContext().config(features);
        ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
        return objectReader.readObject(reader, 0L);
    }

    public static <T> T parseObject(String str, Class<T> objectClass) {
        JSONReader reader = JSONReader.of(str);
        JSONReader.Context context = reader.context;
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(objectClass, fieldBased);
        return objectReader.readObject(reader, 0L);
    }

    public static <T> T parseObject(String str, Type objectType) {
        JSONReader reader = JSONReader.of(str);
        ObjectReader objectReader = reader.context.provider.getObjectReader(objectType);
        return objectReader.readObject(reader, 0L);
    }

    public static <T> T parseObject(String str, Class<T> objectClass, JSONReader.Feature ... features) {
        JSONReader reader = JSONReader.of(str);
        JSONReader.Context context = reader.context;
        context.config(features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(objectClass, fieldBased);
        return objectReader.readObject(reader, 0L);
    }

    public static <T> T parseObject(String str, Class<T> objectClass, String format, JSONReader.Feature ... features) {
        JSONReader reader = JSONReader.of(str);
        JSONReader.Context context = reader.context;
        if (format != null) {
            context.setUtilDateFormat(format);
        }
        context.config(features);
        ObjectReader objectReader = context.provider.getObjectReader(objectClass);
        return objectReader.readObject(reader, 0L);
    }

    public static <T> T parseObject(String str, Type objectType, JSONReader.Feature ... features) {
        JSONReader reader = JSONReader.of(str);
        reader.getContext().config(features);
        ObjectReader objectReader = reader.getObjectReader(objectType);
        return objectReader.readObject(reader, 0L);
    }

    public static <T> T parseObject(byte[] utf8Bytes, Type objectType) {
        JSONReader reader = JSONReader.of(utf8Bytes);
        ObjectReader objectReader = reader.getObjectReader(objectType);
        return objectReader.readObject(reader, 0L);
    }

    public static <T> T parseObject(byte[] utf8Bytes, Class<T> objectClass) {
        JSONReader reader = JSONReader.of(utf8Bytes);
        ObjectReader objectReader = reader.getObjectReader(objectClass);
        return objectReader.readObject(reader, 0L);
    }

    public static <T> T parseObject(byte[] utf8Bytes, Type objectClass, JSONReader.Feature ... features) {
        JSONReader reader = JSONReader.of(utf8Bytes);
        reader.getContext().config(features);
        ObjectReader objectReader = reader.getObjectReader(objectClass);
        return objectReader.readObject(reader, 0L);
    }

    public static <T> T parseObject(byte[] utf8Bytes, int off, int len, Charset charset, Type objectClass) {
        JSONReader reader = JSONReader.of(utf8Bytes, off, len, charset);
        ObjectReader objectReader = reader.getObjectReader(objectClass);
        return objectReader.readObject(reader, 0L);
    }

    public static JSONObject parseObject(String str) {
        JSONReader reader = JSONReader.of(str);
        ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
        return (JSONObject)objectReader.readObject(reader, 0L);
    }

    public static JSONObject parseObject(byte[] ut8Bytes) {
        JSONReader reader = JSONReader.of(ut8Bytes);
        ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONObject.class));
        return (JSONObject)objectReader.readObject(reader, 0L);
    }

    public static JSONArray parseArray(String str) {
        JSONReader reader = JSONReader.of(str);
        ObjectReader objectReader = reader.getObjectReader((Type)((Object)JSONArray.class));
        return (JSONArray)objectReader.readObject(reader, 0L);
    }

    public static <T> List<T> parseArray(String str, Type itemType) {
        ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{itemType}, null, (Type)((Object)List.class));
        JSONReader reader = JSONReader.of(str);
        return (List)reader.read(paramType);
    }

    public static <T> List<T> parseArray(String str, Type[] itemTypes) {
        JSONArray array = new JSONArray(itemTypes.length);
        JSONReader jsonReader = JSONReader.of(str);
        jsonReader.startArray();
        for (Type itemType : itemTypes) {
            array.add(jsonReader.read(itemType));
        }
        jsonReader.endArray();
        return array;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toJSONString(Object object) {
        try (JSONWriter writer = JSONWriter.of();){
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new JSONException("toJSONString error", ex);
        }
    }

    public static String toJSONString(Object object, JSONWriter.Feature ... features) {
        JSONWriter.Context writeContext = new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features);
        boolean pretty = (writeContext.features & JSONWriter.Feature.PrettyFormat.mask) != 0L;
        JSONWriterUTF16 jsonWriterUTF16 = JDKUtils.JVM_VERSION == 8 ? new JSONWriterUTF16JDK8(writeContext) : new JSONWriterUTF16(writeContext);
        try (JSONWriter writer = pretty ? new JSONWriterPretty(jsonWriterUTF16) : jsonWriterUTF16;){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                boolean fieldBased = (writeContext.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                ObjectWriter objectWriter = writeContext.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, Filter[] filters, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                if (filters != null && filters.length != 0) {
                    JSONWriter.Context context = writer.getContext();
                    context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, Filter filter, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                if (filter != null) {
                    JSONWriter.Context context = writer.getContext();
                    context.configFilter(new Filter[]{filter});
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, String format, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                JSONWriter.Context context = writer.getContext();
                context.setDateFormat(format);
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static byte[] toJSONBytes(Object object) {
        try (JSONWriter writer = JSONWriter.ofUTF8();){
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, Filter ... filters) {
        try (JSONWriter writer = JSONWriter.ofUTF8();){
            JSONWriter.Context context = writer.getContext();
            if (filters.length != 0) {
                context.configFilter(filters);
            }
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.ofUTF8(features);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int writeTo(OutputStream out, Object object, JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.ofUTF8(features);){
            int len;
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = len = writer.flushTo(out);
            return n;
        }
        catch (IOException e) {
            throw new JSONException("writeJSONString error", e);
        }
    }

    public static boolean isValid(String str) {
        JSONReader jsonReader = JSONReader.of(str);
        try {
            jsonReader.skipValue();
        }
        catch (JSONException error) {
            return false;
        }
        return true;
    }

    public static boolean isValidArray(String str) {
        JSONReader jsonReader = JSONReader.of(str);
        try {
            if (!jsonReader.isArray()) {
                return false;
            }
            jsonReader.skipValue();
        }
        catch (JSONException error) {
            return false;
        }
        return true;
    }

    public static boolean isValid(byte[] jsonBytes) {
        JSONReader jsonReader = JSONReader.of(jsonBytes);
        try {
            jsonReader.skipValue();
        }
        catch (JSONException error) {
            return false;
        }
        return true;
    }

    public static boolean isValid(byte[] jsonBytes, int offset, int length, Charset charset) {
        JSONReader jsonReader = JSONReader.of(jsonBytes, offset, length, charset);
        try {
            jsonReader.skipValue();
        }
        catch (JSONException error) {
            return false;
        }
        return true;
    }

    public static Object toJSON(Object javaObject) {
        if (javaObject instanceof JSONObject || javaObject instanceof JSONArray) {
            return javaObject;
        }
        String str = JSON.toJSONString(javaObject);
        return JSON.parse(str);
    }

    public static <T> T toJavaObject(Object json, Class<T> clazz) {
        if (json instanceof JSONObject) {
            return ((JSONObject)json).toJavaObject(clazz);
        }
        return TypeUtils.cast(json, clazz);
    }
}

