/*
 * Decompiled with CFR 0.152.
 */
package com.shapestone.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.beans.ConstructorProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Result<D> {
    private D data;
    private boolean fail;
    private String message;

    public Result(D data) {
        this.data = data;
        this.fail = false;
    }

    public Result(boolean fail) {
        this.fail = fail;
    }

    public Result(String message) {
        this.message = message;
    }

    public Result(D data, boolean fail) {
        this.data = data;
        this.fail = fail;
    }

    public Result(D data, String message) {
        this.data = data;
        this.message = message;
    }

    public Result(boolean fail, String message) {
        this.fail = fail;
        this.message = message;
    }

    public boolean notFail() {
        return !this.isFail();
    }

    public static <D> ResultBuilder<D> builder() {
        return new ResultBuilder();
    }

    public D getData() {
        return this.data;
    }

    public boolean isFail() {
        return this.fail;
    }

    public String getMessage() {
        return this.message;
    }

    public void setData(D data) {
        this.data = data;
    }

    public void setFail(boolean fail) {
        this.fail = fail;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        return "Result(data=" + this.getData() + ", fail=" + this.isFail() + ", message=" + this.getMessage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        D this$data = this.getData();
        D other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        if (this.isFail() != other.isFail()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        D $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + (this.isFail() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public Result() {
    }

    @ConstructorProperties(value={"data", "fail", "message"})
    public Result(D data, boolean fail, String message) {
        this.data = data;
        this.fail = fail;
        this.message = message;
    }

    public static class ResultBuilder<D> {
        private D data;
        private boolean fail;
        private String message;

        ResultBuilder() {
        }

        public ResultBuilder<D> data(D data) {
            this.data = data;
            return this;
        }

        public ResultBuilder<D> fail(boolean fail) {
            this.fail = fail;
            return this;
        }

        public ResultBuilder<D> message(String message) {
            this.message = message;
            return this;
        }

        public Result<D> build() {
            return new Result<D>(this.data, this.fail, this.message);
        }

        public String toString() {
            return "Result.ResultBuilder(data=" + this.data + ", fail=" + this.fail + ", message=" + this.message + ")";
        }
    }
}

