/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllExpr;
import com.alibaba.druid.sql.ast.expr.SQLAnyExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLSomeExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.NotNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropForeinKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCharactorDataType;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLColumnPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLColumnReference;
import com.alibaba.druid.sql.ast.statement.SQLColumnUniqueKey;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableSpaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprHint;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLReleaseSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.visitor.PrintableVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitorUtils;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SQLASTOutputVisitor
extends SQLASTVisitorAdapter
implements PrintableVisitor {
    protected final Appendable appender;
    private String indent = "\t";
    private int indentCount = 0;
    private boolean prettyFormat = true;
    protected int selectListNumberOfLine = 5;
    private List<Object> parameters;

    public SQLASTOutputVisitor(Appendable appender) {
        this.appender = appender;
    }

    public int getParametersSize() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public List<Object> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        return this.parameters;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public int getIndentCount() {
        return this.indentCount;
    }

    public Appendable getAppender() {
        return this.appender;
    }

    public boolean isPrettyFormat() {
        return this.prettyFormat;
    }

    public void setPrettyFormat(boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
    }

    public void decrementIndent() {
        --this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    @Override
    public void print(char value) {
        try {
            this.appender.append(value);
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    public void print(int value) {
        this.print(Integer.toString(value));
    }

    public void print(Date date) {
        SimpleDateFormat dateFormat = date instanceof Timestamp ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS") : new SimpleDateFormat("yyyy-MM-dd");
        this.print("'" + dateFormat.format(date) + "'");
    }

    public void print(long value) {
        this.print(Long.toString(value));
    }

    @Override
    public void print(String text) {
        try {
            this.appender.append(text);
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    protected void printAlias(String alias) {
        if (alias != null && alias.length() > 0) {
            this.print(" ");
            this.print(alias);
        }
    }

    protected void printAndAccept(List<? extends SQLObject> nodes, String seperator) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(seperator);
            }
            nodes.get(i).accept(this);
        }
    }

    protected void printSelectList(List<SQLSelectItem> selectList) {
        this.incrementIndent();
        int size = selectList.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                if (i % this.selectListNumberOfLine == 0) {
                    this.println();
                }
                this.print(", ");
            }
            selectList.get(i).accept(this);
        }
        this.decrementIndent();
    }

    protected void printlnAndAccept(List<? extends SQLObject> nodes, String seperator) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println(seperator);
            }
            nodes.get(i).accept(this);
        }
    }

    public void printIndent() {
        for (int i = 0; i < this.indentCount; ++i) {
            this.print(this.indent);
        }
    }

    public void println() {
        if (!this.isPrettyFormat()) {
            this.print(' ');
            return;
        }
        this.print("\n");
        this.printIndent();
    }

    public void println(String text) {
        this.print(text);
        this.println();
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        x.getTestExpr().accept(this);
        if (x.isNot()) {
            this.print(" NOT BETWEEN ");
        } else {
            this.print(" BETWEEN ");
        }
        x.getBeginExpr().accept(this);
        this.print(" AND ");
        x.getEndExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        boolean relational;
        SQLObject parent = x.getParent();
        boolean isRoot = parent instanceof SQLSelectQueryBlock;
        boolean bl = relational = x.getOperator() == SQLBinaryOperator.BooleanAnd || x.getOperator() == SQLBinaryOperator.BooleanOr;
        if (isRoot && relational) {
            this.incrementIndent();
        }
        ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>();
        SQLExpr left = x.getLeft();
        while (left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)left).getOperator() == x.getOperator()) {
            SQLBinaryOpExpr binaryLeft = (SQLBinaryOpExpr)left;
            groupList.add(binaryLeft.getRight());
            left = binaryLeft.getLeft();
        }
        groupList.add(left);
        for (int i = groupList.size() - 1; i >= 0; --i) {
            SQLExpr item = (SQLExpr)groupList.get(i);
            this.visitBinaryLeft(item, x.getOperator());
            if (relational) {
                this.println();
            } else {
                this.print(" ");
            }
            this.print(x.getOperator().name);
            this.print(" ");
        }
        this.visitorBinaryRight(x);
        if (isRoot && relational) {
            this.decrementIndent();
        }
        return false;
    }

    private void visitorBinaryRight(SQLBinaryOpExpr x) {
        if (x.getRight() instanceof SQLBinaryOpExpr) {
            boolean rightRational;
            SQLBinaryOpExpr right = (SQLBinaryOpExpr)x.getRight();
            boolean bl = rightRational = right.getOperator() == SQLBinaryOperator.BooleanAnd || right.getOperator() == SQLBinaryOperator.BooleanOr;
            if (right.getOperator().priority >= x.getOperator().priority) {
                if (rightRational) {
                    this.incrementIndent();
                }
                this.print('(');
                right.accept(this);
                this.print(')');
                if (rightRational) {
                    this.decrementIndent();
                }
            } else {
                right.accept(this);
            }
        } else {
            x.getRight().accept(this);
        }
    }

    private void visitBinaryLeft(SQLExpr left, SQLBinaryOperator op) {
        if (left instanceof SQLBinaryOpExpr) {
            boolean leftRational;
            SQLBinaryOpExpr binaryLeft = (SQLBinaryOpExpr)left;
            boolean bl = leftRational = binaryLeft.getOperator() == SQLBinaryOperator.BooleanAnd || binaryLeft.getOperator() == SQLBinaryOperator.BooleanOr;
            if (binaryLeft.getOperator().priority > op.priority) {
                if (leftRational) {
                    this.incrementIndent();
                }
                this.print('(');
                left.accept(this);
                this.print(')');
                if (leftRational) {
                    this.decrementIndent();
                }
            } else {
                left.accept(this);
            }
        } else {
            left.accept(this);
        }
    }

    @Override
    public boolean visit(SQLCaseExpr x) {
        this.print("CASE ");
        if (x.getValueExpr() != null) {
            x.getValueExpr().accept(this);
            this.print(" ");
        }
        this.printAndAccept(x.getItems(), " ");
        if (x.getElseExpr() != null) {
            this.print(" ELSE ");
            x.getElseExpr().accept(this);
        }
        this.print(" END");
        return false;
    }

    @Override
    public boolean visit(SQLCaseExpr.Item x) {
        this.print("WHEN ");
        x.getConditionExpr().accept(this);
        this.print(" THEN ");
        x.getValueExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCastExpr x) {
        this.print("CAST(");
        x.getExpr().accept(this);
        this.print(" AS ");
        x.getDataType().accept(this);
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        if (x.getText() == null || x.getText().length() == 0) {
            this.print("NULL");
        } else {
            this.print("'");
            this.print(x.getText().replaceAll("'", "''"));
            this.print("'");
        }
        return false;
    }

    @Override
    public boolean visit(SQLDataType x) {
        this.print(x.getName());
        if (x.getArguments().size() > 0) {
            this.print("(");
            this.printAndAccept(x.getArguments(), ", ");
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(SQLCharactorDataType x) {
        this.visit((SQLDataType)x);
        return false;
    }

    @Override
    public boolean visit(SQLExistsExpr x) {
        if (x.isNot()) {
            this.print("NOT EXISTS (");
        } else {
            this.print("EXISTS (");
        }
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        this.print(x.getName());
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        x.getExpr().accept(this);
        if (x.isNot()) {
            this.print(" NOT IN (");
        } else {
            this.print(" IN (");
        }
        this.printAndAccept(x.getTargetList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        return SQLASTOutputVisitorUtils.visit((PrintableVisitor)this, x);
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if (x.getOwner() != null) {
            x.getOwner().accept(this);
            this.print(".");
        }
        this.print(x.getMethodName());
        this.print("(");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        this.print(x.getMethodName());
        this.print("(");
        if (x.getOption() != null) {
            this.print(x.getOption().toString());
            this.print(' ');
        }
        this.printAndAccept(x.getArguments(), ", ");
        this.visitAggreateRest(x);
        this.print(")");
        if (x.getWithinGroup() != null) {
            this.print(" WITHIN GROUP (");
            x.getWithinGroup().accept(this);
            this.print(")");
        }
        if (x.getOver() != null) {
            this.print(" ");
            x.getOver().accept(this);
        }
        return false;
    }

    protected void visitAggreateRest(SQLAggregateExpr aggregateExpr) {
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        this.print("*");
        return true;
    }

    @Override
    public boolean visit(SQLNCharExpr x) {
        if (x.getText() == null || x.getText().length() == 0) {
            this.print("NULL");
        } else {
            this.print("N'");
            this.print(x.getText().replace("'", "''"));
            this.print("'");
        }
        return false;
    }

    @Override
    public boolean visit(SQLNotExpr x) {
        this.print("NOT ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLNullExpr x) {
        this.print("NULL");
        return false;
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        return SQLASTOutputVisitorUtils.visit((PrintableVisitor)this, x);
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        x.getOwner().accept(this);
        this.print(".");
        this.print(x.getName());
        return false;
    }

    @Override
    public boolean visit(SQLQueryExpr x) {
        SQLObject parent = x.getParent();
        if (parent instanceof SQLSelect) {
            parent = parent.getParent();
        }
        if (parent instanceof SQLStatement) {
            this.incrementIndent();
            this.println();
            x.getSubQuery().accept(this);
            this.decrementIndent();
        } else if (parent instanceof SQLInsertStatement.ValuesClause) {
            this.println();
            this.print("(");
            x.getSubQuery().accept(this);
            this.print(")");
            this.println();
        } else {
            this.print("(");
            this.incrementIndent();
            this.println();
            x.getSubQuery().accept(this);
            this.println();
            this.decrementIndent();
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        if (x.getItems().size() > 0) {
            this.print("GROUP BY ");
            this.printAndAccept(x.getItems(), ", ");
        }
        if (x.getHaving() != null) {
            this.println();
            this.print("HAVING ");
            x.getHaving().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        x.getQuery().setParent(x);
        if (x.getWithSubQuery() != null) {
            x.getWithSubQuery().accept(this);
            this.println();
        }
        x.getQuery().accept(this);
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getHintsSize() > 0) {
            this.printAndAccept(x.getHints(), "");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        this.print("SELECT ");
        if (1 == x.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == x.getDistionOption()) {
            this.print("DISTINCT ");
        } else if (3 == x.getDistionOption()) {
            this.print("UNIQUE ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getFrom() != null) {
            this.println();
            this.print("FROM ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        if (x.isConnectByRoot()) {
            this.print("CONNECT_BY_ROOT ");
        }
        x.getExpr().accept(this);
        if (x.getAlias() != null && x.getAlias().length() > 0) {
            this.print(" AS ");
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        if (x.getItems().size() > 0) {
            this.print("ORDER BY ");
            this.printAndAccept(x.getItems(), ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectOrderByItem x) {
        x.getExpr().accept(this);
        if (x.getType() != null) {
            this.print(" ");
            this.print(x.getType().name().toUpperCase());
        }
        if (x.getCollate() != null) {
            this.print(" COLLATE ");
            this.print(x.getCollate());
        }
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null) {
            this.print(' ');
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectStatement stmt) {
        SQLSelect select = stmt.getSelect();
        select.accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        int index = x.getIndex();
        if (this.parameters == null || index >= this.parameters.size()) {
            this.print(x.getName());
            return false;
        }
        Object param = this.parameters.get(index);
        this.printParameter(param);
        return false;
    }

    public void printParameter(Object param) {
        if (param == null) {
            this.print("NULL");
            return;
        }
        if (param instanceof Number || param instanceof Boolean) {
            this.print(param.toString());
            return;
        }
        if (param instanceof String) {
            SQLCharExpr charExpr = new SQLCharExpr((String)param);
            this.visit(charExpr);
            return;
        }
        if (param instanceof Date) {
            this.print((Date)param);
            return;
        }
        if (param instanceof InputStream) {
            this.print("'<InputStream>");
            return;
        }
        if (param instanceof Reader) {
            this.print("'<Reader>");
            return;
        }
        if (param instanceof Blob) {
            this.print("'<Blob>");
            return;
        }
        if (param instanceof NClob) {
            this.print("'<NClob>");
            return;
        }
        if (param instanceof Clob) {
            this.print("'<Clob>");
            return;
        }
        this.print("'" + param.getClass().getName() + "'");
    }

    @Override
    public boolean visit(SQLDropTableStatement x) {
        if (x.isTemporary()) {
            this.print("DROP TEMPORARY TABLE ");
        } else {
            this.print("DROP TABLE ");
        }
        if (x.isIfExists()) {
            this.print("IF EXISTS ");
        }
        this.printAndAccept(x.getTableSources(), ", ");
        if (x.isCascade()) {
            this.printCascade();
        }
        if (x.isRestrict()) {
            this.print(" RESTRICT");
        }
        if (x.isPurge()) {
            this.print(" PURGE");
        }
        return false;
    }

    protected void printCascade() {
        this.print(" CASCADE");
    }

    @Override
    public boolean visit(SQLDropViewStatement x) {
        this.print("DROP VIEW ");
        if (x.isIfExists()) {
            this.print("IF EXISTS ");
        }
        this.printAndAccept(x.getTableSources(), ", ");
        if (x.isCascade()) {
            this.printCascade();
        }
        return false;
    }

    public boolean visit(SQLTableElement x) {
        if (x instanceof SQLColumnDefinition) {
            return this.visit((SQLColumnDefinition)x);
        }
        throw new RuntimeException("TODO");
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        x.getName().accept(this);
        if (x.getDataType() != null) {
            this.print(' ');
            x.getDataType().accept(this);
        }
        if (x.getDefaultExpr() != null) {
            this.visitColumnDefault(x);
        }
        for (SQLColumnConstraint item : x.getConstaints()) {
            boolean newLine;
            boolean bl = newLine = item instanceof SQLForeignKeyConstraint || item instanceof SQLPrimaryKey || item instanceof SQLColumnCheck || item instanceof SQLColumnCheck || item.getName() != null;
            if (newLine) {
                this.incrementIndent();
                this.println();
            } else {
                this.print(' ');
            }
            item.accept(this);
            if (!newLine) continue;
            this.decrementIndent();
        }
        if (x.getEnable() != null && x.getEnable().booleanValue()) {
            this.print(" ENABLE");
        }
        if (x.getComment() != null) {
            this.print(" COMMENT ");
            x.getComment().accept(this);
        }
        return false;
    }

    protected void visitColumnDefault(SQLColumnDefinition x) {
        this.print(" DEFAULT ");
        x.getDefaultExpr().accept(this);
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        this.print("DELETE FROM ");
        x.getTableName().accept(this);
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCurrentOfCursorExpr x) {
        this.print("CURRENT OF ");
        x.getCursorName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        this.print("INSERT INTO ");
        x.getTableSource().accept(this);
        if (x.getColumns().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print("(");
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
            this.decrementIndent();
        }
        if (x.getValues() != null) {
            this.println();
            this.print("VALUES");
            this.println();
            x.getValues().accept(this);
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().setParent(x);
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLUpdateSetItem x) {
        x.getColumn().accept(this);
        this.print(" = ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        this.print("UPDATE ");
        x.getTableSource().accept(this);
        this.println();
        this.print("SET ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        this.print("CREATE TABLE ");
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)x.getType())) {
            this.print("GLOBAL TEMPORARY ");
        } else if (SQLCreateTableStatement.Type.LOCAL_TEMPORARY.equals((Object)x.getType())) {
            this.print("LOCAL TEMPORARY ");
        }
        x.getName().accept(this);
        int size = x.getTableElementList().size();
        if (size > 0) {
            this.print(" (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(",");
                    this.println();
                }
                x.getTableElementList().get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(")");
        }
        return false;
    }

    public boolean visit(SQLUniqueConstraint x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print("UNIQUE (");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(NotNullConstraint x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print("NOT NULL");
        return false;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        x.getLeft().accept(this);
        this.println();
        this.print(x.getOperator().name);
        this.println();
        boolean needParen = false;
        if (x.getOrderBy() != null) {
            needParen = true;
        }
        if (needParen) {
            this.print('(');
            x.getRight().accept(this);
            this.print(')');
        } else {
            x.getRight().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLUnaryExpr x) {
        this.print(x.getOperator().name);
        SQLExpr expr = x.getExpr();
        switch (x.getOperator()) {
            case BINARY: 
            case Prior: 
            case ConnectByRoot: {
                this.print(' ');
                expr.accept(this);
                return false;
            }
        }
        if (expr instanceof SQLBinaryOpExpr) {
            this.print('(');
            expr.accept(this);
            this.print(')');
        } else if (expr instanceof SQLUnaryExpr) {
            this.print('(');
            expr.accept(this);
            this.print(')');
        } else {
            expr.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLHexExpr x) {
        this.print("0x");
        this.print(x.getHex());
        String charset = (String)x.getAttribute("USING");
        if (charset != null) {
            this.print(" USING ");
            this.print(charset);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSetStatement x) {
        this.print("SET ");
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLAssignItem x) {
        x.getTarget().accept(this);
        this.print(" = ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCallStatement x) {
        if (x.isBrace()) {
            this.print("{");
        }
        if (x.getOutParameter() != null) {
            x.getOutParameter().accept(this);
            this.print(" = ");
        }
        this.print("CALL ");
        x.getProcedureName().accept(this);
        this.print('(');
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        if (x.isBrace()) {
            this.print("}");
        }
        return false;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        x.getLeft().accept(this);
        this.incrementIndent();
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print(",");
        } else {
            this.println();
            this.print(SQLJoinTableSource.JoinType.toString(x.getJoinType()));
        }
        this.print(" ");
        x.getRight().accept(this);
        if (x.getCondition() != null) {
            this.incrementIndent();
            this.print(" ON ");
            x.getCondition().accept(this);
            this.decrementIndent();
        }
        if (x.getUsing().size() > 0) {
            this.print(" USING (");
            this.printAndAccept(x.getUsing(), ", ");
            this.print(")");
        }
        if (x.getAlias() != null) {
            this.print(" AS ");
            this.print(x.getAlias());
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement.ValuesClause x) {
        this.print("(");
        this.incrementIndent();
        int size = x.getValues().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                if (i % 5 == 0) {
                    this.println();
                }
                this.print(", ");
            }
            SQLExpr expr = x.getValues().get(i);
            expr.setParent(x);
            expr.accept(this);
        }
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLSomeExpr x) {
        this.print("SOME (");
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAnyExpr x) {
        this.print("ANY (");
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAllExpr x) {
        this.print("ALL (");
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLInSubQueryExpr x) {
        x.getExpr().accept(this);
        if (x.isNot()) {
            this.print(" NOT IN (");
        } else {
            this.print(" IN (");
        }
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLListExpr x) {
        this.print("(");
        this.printAndAccept(x.getItems(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.print("(");
        this.incrementIndent();
        x.getSelect().accept(this);
        this.println();
        this.decrementIndent();
        this.print(")");
        if (x.getAlias() != null) {
            this.print(' ');
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLTruncateStatement x) {
        this.print("TRUNCATE TABLE ");
        this.printAndAccept(x.getTableSources(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLDefaultExpr x) {
        this.print("DEFAULT");
        return false;
    }

    @Override
    public void endVisit(SQLCommentStatement x) {
    }

    @Override
    public boolean visit(SQLCommentStatement x) {
        this.print("COMMENT ON ");
        if (x.getType() != null) {
            this.print(x.getType().name());
            this.print(" ");
        }
        x.getOn().accept(this);
        this.print(" IS ");
        x.getComment().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLUseStatement x) {
        this.print("USE ");
        x.getDatabase().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        this.print("ADD (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropColumnItem x) {
        this.print("DROP COLUMN ");
        this.printAndAccept(x.getColumns(), ", ");
        return false;
    }

    @Override
    public void endVisit(SQLAlterTableAddColumn x) {
    }

    @Override
    public boolean visit(SQLDropIndexStatement x) {
        this.print("DROP INDEX ");
        x.getIndexName().accept(this);
        SQLExprTableSource table = x.getTableName();
        if (table != null) {
            this.print(" ON ");
            table.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSavePointStatement x) {
        this.print("SAVEPOINT ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLReleaseSavePointStatement x) {
        this.print("RELEASE SAVEPOINT ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLRollbackStatement x) {
        this.print("ROLLBACK");
        if (x.getTo() != null) {
            this.print(" TO ");
            x.getTo().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCommentHint x) {
        this.print("/*");
        this.print(x.getText());
        this.print("*/");
        return false;
    }

    @Override
    public boolean visit(SQLCreateDatabaseStatement x) {
        this.print("CREATE DATABASE ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateViewStatement x) {
        this.print("CREATE ");
        if (x.isOrReplace()) {
            this.print("OR REPLACE ");
        }
        this.print("VIEW ");
        x.getName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(")");
        }
        this.print(" AS ");
        x.getSubQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropIndex x) {
        this.print("DROP INDEX ");
        x.getIndexName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLOver x) {
        this.print("OVER (");
        if (x.getPartitionBy().size() > 0) {
            this.print("PARTITION BY ");
            this.printAndAccept(x.getPartitionBy(), ", ");
            this.print(' ');
        }
        if (x.getOrderBy() != null) {
            x.getOrderBy().accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLColumnPrimaryKey x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print("PRIMARY KEY");
        return false;
    }

    @Override
    public boolean visit(SQLColumnUniqueKey x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print("UNIQUE");
        return false;
    }

    @Override
    public boolean visit(SQLColumnCheck x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print("CHECK (");
        x.getExpr().accept(this);
        this.print(')');
        if (x.getEnable() != null) {
            if (x.getEnable().booleanValue()) {
                this.print(" ENABLE");
            } else {
                this.print(" DISABLE");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause x) {
        this.print("WITH");
        if (x.getRecursive() == Boolean.TRUE) {
            this.print(" RECURSIVE");
        }
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getEntries(), ", ");
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        x.getName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(")");
        }
        this.println();
        this.print("AS");
        this.println();
        this.print("(");
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAlterColumn x) {
        this.print("ALTER COLUMN ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCheck x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print("CHECK (");
        this.incrementIndent();
        x.getExpr().accept(this);
        this.decrementIndent();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropForeinKey x) {
        this.print("DROP FOREIGN KEY ");
        x.getIndexName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropPrimaryKey x) {
        this.print("DROP PRIMARY KEY");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableEnableKeys x) {
        this.print("ENABLE KEYS");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDisableKeys x) {
        this.print("DISABLE KEYS");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDisableConstraint x) {
        this.print("DISABLE CONSTRAINT ");
        x.getConstraintName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableEnableConstraint x) {
        this.print("ENABLE CONSTRAINT ");
        x.getConstraintName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropConstraint x) {
        this.print("DROP CONSTRAINT ");
        x.getConstraintName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableStatement x) {
        this.print("ALTER TABLE ");
        x.getName().accept(this);
        this.incrementIndent();
        for (int i = 0; i < x.getItems().size(); ++i) {
            SQLAlterTableItem item = x.getItems().get(i);
            if (i != 0) {
                this.print(',');
            }
            this.println();
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLExprHint x) {
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        this.print("CREATE ");
        if (x.getType() != null) {
            this.print(x.getType());
            this.print(" ");
        }
        this.print("INDEX ");
        x.getName().accept(this);
        this.print(" ON ");
        x.getTable().accept(this);
        this.print(" (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLUnique x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(" ");
        }
        this.print("UNIQUE (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLPrimaryKeyImpl x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(" ");
        }
        this.print("PRIMARY KEY (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRenameColumn x) {
        this.print("RENAME COLUMN ");
        x.getColumn().accept(this);
        this.print(" TO ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLColumnReference x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(" ");
        }
        this.print("REFERENCES ");
        x.getTable().accept(this);
        this.print(" (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLForeignKeyImpl x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print("FOREIGN KEY (");
        this.printAndAccept(x.getReferencingColumns(), ", ");
        this.print(")");
        this.print(" REFERENCES ");
        x.getReferencedTableName().accept(this);
        this.print(" (");
        this.printAndAccept(x.getReferencedColumns(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLDropSequenceStatement x) {
        this.print("DROP SEQUENCE ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(SQLDropSequenceStatement x) {
    }

    @Override
    public boolean visit(SQLDropTriggerStatement x) {
        this.print("DROP TRIGGER ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(SQLDropUserStatement x) {
    }

    @Override
    public boolean visit(SQLDropUserStatement x) {
        this.print("DROP USER ");
        this.printAndAccept(x.getUsers(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLExplainStatement x) {
        this.print("EXPLAIN");
        this.println();
        x.getStatement().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLGrantStatement x) {
        this.print("GRANT ");
        this.printAndAccept(x.getPrivileges(), ", ");
        if (x.getOn() != null) {
            this.print(" ON ");
            if (x.getObjectType() != null) {
                this.print(x.getObjectType().name());
                this.print(' ');
            }
            x.getOn().accept(this);
        }
        if (x.getTo() != null) {
            this.print(" TO ");
            x.getTo().accept(this);
        }
        boolean with = false;
        if (x.getMaxQueriesPerHour() != null) {
            if (!with) {
                this.print(" WITH");
                with = true;
            }
            this.print(" MAX_QUERIES_PER_HOUR ");
            x.getMaxQueriesPerHour().accept(this);
        }
        if (x.getMaxUpdatesPerHour() != null) {
            if (!with) {
                this.print(" WITH");
                with = true;
            }
            this.print(" MAX_UPDATES_PER_HOUR ");
            x.getMaxUpdatesPerHour().accept(this);
        }
        if (x.getMaxConnectionsPerHour() != null) {
            if (!with) {
                this.print(" WITH");
                with = true;
            }
            this.print(" MAX_CONNECTIONS_PER_HOUR ");
            x.getMaxConnectionsPerHour().accept(this);
        }
        if (x.getMaxUserConnections() != null) {
            if (!with) {
                this.print(" WITH");
                with = true;
            }
            this.print(" MAX_USER_CONNECTIONS ");
            x.getMaxUserConnections().accept(this);
        }
        if (x.isAdminOption()) {
            if (!with) {
                this.print(" WITH");
                with = true;
            }
            this.print(" ADMIN OPTION");
        }
        if (x.getIdentifiedBy() != null) {
            this.print(" IDENTIFIED BY ");
            x.getIdentifiedBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropDatabaseStatement x) {
        this.print("DROP DATABASE ");
        if (x.isIfExists()) {
            this.print("IF EXISTS ");
        }
        x.getDatabase().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropFunctionStatement x) {
        this.print("DROP FUNCTION ");
        if (x.isIfExists()) {
            this.print("IF EXISTS ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropTableSpaceStatement x) {
        this.print("DROP TABLESPACE ");
        if (x.isIfExists()) {
            this.print("IF EXISTS ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropProcedureStatement x) {
        this.print("DROP PROCEDURE ");
        if (x.isIfExists()) {
            this.print("IF EXISTS ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddIndex x) {
        this.print("ADD ");
        if (x.getType() != null) {
            this.print(x.getType());
            this.print(" ");
        }
        if (x.isUnique()) {
            this.print("UNIQUE ");
        }
        this.print("INDEX ");
        if (x.getName() != null) {
            x.getName().accept(this);
            this.print(' ');
        }
        this.print("(");
        this.printAndAccept(x.getItems(), ", ");
        this.print(")");
        if (x.getUsing() != null) {
            this.print(" USING ");
            this.print(x.getUsing());
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddConstraint x) {
        if (x.isWithNoCheck()) {
            this.print("WITH NOCHECK ");
        }
        this.print("ADD ");
        x.getConstraint().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateTriggerStatement x) {
        this.print("CREATE ");
        if (x.isOrReplace()) {
            this.print("OR REPLEACE ");
        }
        this.print("TRIGGER ");
        x.getName().accept(this);
        this.incrementIndent();
        this.println();
        if (SQLCreateTriggerStatement.TriggerType.INSTEAD_OF.equals((Object)x.getTriggerType())) {
            this.print("INSTEAD OF");
        } else {
            this.print(x.getTriggerType().name());
        }
        for (SQLCreateTriggerStatement.TriggerEvent event : x.getTriggerEvents()) {
            this.print(' ');
            this.print(event.name());
        }
        this.println();
        this.print("ON ");
        x.getOn().accept(this);
        if (x.isForEachRow()) {
            this.println();
            this.print("FOR EACH ROW");
        }
        this.decrementIndent();
        this.println();
        x.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLBooleanExpr x) {
        this.print(x.getValue() ? "true" : "false");
        return false;
    }

    @Override
    public void endVisit(SQLBooleanExpr x) {
    }

    @Override
    public boolean visit(SQLUnionQueryTableSource x) {
        this.print("(");
        this.incrementIndent();
        x.getUnion().accept(this);
        this.println();
        this.decrementIndent();
        this.print(")");
        if (x.getAlias() != null) {
            this.print(' ');
            this.print(x.getAlias());
        }
        return false;
    }
}

